#!/bin/bash -e

source /usr/lib/qloud-functions.sh

mkdir -p /etc/yandex

if [[ "${ENVIRONMENT_TYPE}" ]]; then
    if [[ "${ENVIRONMENT_NAME}" ]]; then
        ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_NAME" > /etc/yandex/environment.name
    else
        ENVIRONMENT="${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_TYPE" > /etc/yandex/environment.type
    fi
else
    echo "ENVIRONMENT_TYPE not set, cannot start"
    exit 1
fi

case "$ENVIRONMENT" in
    production|prestable|intranet-production|intranet-prestable)
        ATTACHSID_SECRET_ID=sec-01db2sdc5cdnrjw62k3gr8ckcn
        ATTACHSID_AES_KEY_ID='webmail-production-attachsid-aes-key'
        ATTACHSID_HMAC_KEY_ID='webmail-production-attachsid-hmac-key'
        ;;
    testing|load)
        ATTACHSID_SECRET_ID=sec-01day8mapnzbrqy79jb4bnmghc
        ATTACHSID_AES_KEY_ID='webmail-testing-attachsid-aes-key'
        ATTACHSID_HMAC_KEY_ID='webmail-testing-attachsid-hmac-key'
        ;;
    *)
        echo "Unknown environment type: $ENVIRONMENT_TYPE, cannot start"
        exit 1
        ;;
esac

# make 10 attemps in case of any problems
for i in {1..10}; do
    if check_ephemeral; then
        qloud_link_recursive /var/log
        qloud_link_recursive /app/log
        qloud_link_recursive /var/lib/push-client
        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for srv in $(echo "dict.dict queryrec.dict queryrec.weights"); do
    for i in {1..10}; do
        if [[ -f "/usr/share/recognizer/$srv" ]]; then
            echo "ok"
            break
        else
            echo "No $srv found, sleeping"
            sleep 5
        fi
    done

    if [[ "$i" -eq 10 ]]; then
        echo "Failed to find $srv, cannot start"
        exit 1
    fi
done

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/mulcagate_url_key.txt ]]; then
        echo "copying mulcagate url key"
        cp -f /secrets/mulcagate_url_key.txt /app/secrets/mulcagate_url_key.txt

        echo "chowning mulcagate url key"
        chown app:app /app/secrets/mulcagate_url_key.txt

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No mulcagate url key found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
ATTACHSID_AES_TARGET_PATH=/app/secrets/attach_sid_aes_keys.json
for i in {1..10}; do
    echo "getting attach_sid_aes_keys.json"
    yav get version ${ATTACHSID_SECRET_ID} -o ${ATTACHSID_AES_KEY_ID} > ${ATTACHSID_AES_TARGET_PATH}

    if [[ -s ${ATTACHSID_AES_TARGET_PATH} ]]; then
        echo "chown/chmod ${ATTACHSID_AES_TARGET_PATH}"
        chown app:app ${ATTACHSID_AES_TARGET_PATH} && chmod 600 ${ATTACHSID_AES_TARGET_PATH}

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No ${ATTACHSID_AES_TARGET_PATH} found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to get attach_sid_aes_keys.json, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
ATTACHSID_HMAC_TARGET_PATH=/app/secrets/attach_sid_hmac_keys.json
for i in {1..10}; do
    echo "getting attach_sid_hmac_keys.json"
    yav get version ${ATTACHSID_SECRET_ID} -o ${ATTACHSID_HMAC_KEY_ID} > ${ATTACHSID_HMAC_TARGET_PATH}

    if [[ -s ${ATTACHSID_HMAC_TARGET_PATH} ]]; then
        echo "chown/chmod ${ATTACHSID_HMAC_TARGET_PATH}"
        chown app:app ${ATTACHSID_HMAC_TARGET_PATH} && chmod 600 ${ATTACHSID_HMAC_TARGET_PATH}

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No ${ATTACHSID_HMAC_TARGET_PATH} found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to get attach_sid_hmac_keys.json, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /secrets/ssl ]]; then
        echo "copying crt"
        case "$ENVIRONMENT" in
            production)
                cp -f /secrets/ssl/webattach.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            intranet-production)
                cp -f /secrets/ssl/webattachcorp.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            testing|load|prestable|intranet-prestable)
                cp -f /secrets/ssl/star.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            *)
                echo "Unknown environment type: $ENVIRONMENT_TYPE, cannot start"
                exit 1
                ;;
        esac

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No crt, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/retriever-tvm_secret ]]; then
        echo "copying tvm_secret"
        cp -f /secrets/retriever-tvm_secret /app/secrets/tvm_secret

        echo "chowning tvmpass"
        chown app:app /app/secrets/tvm_secret

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No tvm_secret found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to chown tvm_secret, cannot start"
    exit 1
fi

ln -sf /app/config/config-${ENVIRONMENT}.yml /app/config/config.yml
ln -sf /etc/nginx/sites-available/retriever.conf-${ENVIRONMENT} /etc/nginx/sites-enabled/retriever.conf

QLOUD_COMPONENT=$(cat /etc/qloud/meta.json | jq '.user_environment' | jq '.QLOUD_COMPONENT'  | sed 's/"//g')

# ua proxy tunnel
if [[ "${QLOUD_COMPONENT}" == "retriever-ua1" ]] || [[ "${QLOUD_COMPONENT}" == "retriever-ua2" ]] || [[ "${QLOUD_COMPONENT}" == "retriever-ua3" ]] || [[ "${QLOUD_COMPONENT}" == "retriever-ua4" ]]; then
    /app/qloud/cogent_tun.sh

    if [[ "$?" != 0 ]]; then
        echo "Failed to bring up cogent tunnel"
        exit 1
    fi
fi

# sending retriever logs from production and intranet-production environments
if [[ "${ENVIRONMENT}" == "production" ]] || [[ "${ENVIRONMENT}" == "intranet-production" ]]; then
    push_client_link
    ln -svf /app/push-client/${ENVIRONMENT}.yml /etc/push-client/
fi

/usr/bin/supervisord -n -c /etc/supervisor/supervisord.conf