#!/bin/bash

LOCAL_V6=$DEPLOY_POD_IP_0_ADDRESS

UATUN_V4_MASK="5.45.202.0/24"

echo "[INFO] Started"


# add rule
ip rule show | grep "$UATUN_V4_MASK" > /dev/null 2>&1
if [[ "$?" != 0 ]]; then
    echo "[INFO] Rule for $UATUN_V4_MASK does not exist, adding"

    ip rule add from $UATUN_V4_MASK table 0xffff
    if [[ "$?" != 0 ]]; then
        echo "[ERROR] Failed to run ip rule add from $UATUN_V4_MASK table 0xffff"
        exit 1
    fi
else
    echo "[INFO] Rule for $UATUN_V4_MASK already exists"
fi


# add tunnel
ip -6 tunnel show UaTUN > /dev/null 2>&1
if [[ "$?" != 0 ]]; then
    echo "[INFO] Tunnel UaTUN does not exist, adding"

    ip -6 tunnel add UaTUN mode ipip6 remote $UATUN_DECAP_V6 local $LOCAL_V6
    if [[ "$?" != 0 ]]; then
        echo "[ERROR] Failed to run ip -6 tunnel add UaTUN mode ipip6 remote $UATUN_DECAP_V6 local $LOCAL_V6"
        exit 1
    fi
else
    echo "[INFO] Tunnel UaTUN already exists"
fi


# tunnel up
ip link show UaTUN | grep UP > /dev/null 2>&1
if [[ "$?" != 0 ]]; then
    echo "[INFO] Tunnel UaTUN status is not UP"

    ip link set UaTUN up
    if [[ "$?" != 0 ]]; then
        echo "[ERROR] Failed to run ip link set UaTUN up"
        exit 1
    fi
else
    echo "[INFO] Tunnel UaTUN status is already UP"
fi


# add route
ip route show table 0xffff | grep UaTUN > /dev/null 2>&1
if [[ "$?" != 0 ]]; then
    echo "[INFO] Route for UaTUN does not exist"

    ip route add default dev UaTUN table 0xffff mtu 1400 advmss 1360
    if [[ "$?" != 0 ]]; then
        echo "[ERROR] Failed to run ip route add default dev UaTUN table 0xffff mtu 1400 advmss 1360"
        exit 1
    fi
else
    echo "[INFO] Route for UaTUN already exists"
fi


# hack for ua tun decap
ip -4 route show table all | grep "default dev tun0"> /dev/null 2>&1
if [[ "$?" != 0 ]]; then
    echo "[INFO] Route for tun0 doesn't exist"
else
    ip route del default dev tun0
    if [[ "$?" != 0 ]]; then
        echo "[ERROR] Failed to run ip route del default dev tun0"
        exit 1
    fi
fi


echo "[INFO] Done"

