#pragma once

#include <src/services/hound/hound_client.hpp>
#include <src/services/resize/resize_client_impl.hpp>
#include <mail_getter/mulcagate/mulcagate_client.h>
#include <mail_getter/AttachShieldCrypto.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>

YREFLECTION_ADAPT_ADT(retriever::HoundClientImpl::Timeouts,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_ms, yplatform::time_traits::milliseconds, connect)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, total_ms, yplatform::time_traits::milliseconds, total)
)

BOOST_FUSION_DEFINE_STRUCT((retriever), HoundConfig,
    (std::string, http_client_module)
    (std::string, location)
    (retriever::HoundClientImpl::Timeouts, timeouts)
    (std::size_t, retries)
    (std::string, service_name)
)

BOOST_FUSION_ADAPT_STRUCT(retriever::ResizeClientImpl::Config::Genurl,
    cluster_client_module
)

BOOST_FUSION_ADAPT_STRUCT(retriever::ResizeClientImpl::Config::Get,
    http_client_module,

    location,
    timeouts,
    retries
)

BOOST_FUSION_DEFINE_STRUCT((retriever), ResizeConfig,
    (retriever::ResizeClientImpl::Config::Genurl, genurl)
    (retriever::ResizeClientImpl::Config::Get, get)
)

namespace retriever {

struct MulcagateConfig {
    MulcagateConfig() {
        settings->retries = 1;
    }

    std::string cluster_client_module;
    mail_getter::mulcagate::SettingsPtr settings = std::make_shared<mail_getter::mulcagate::Settings>();
};

struct MulcagateUrlConfig {
    std::string host;
    std::uint16_t port;
    std::string key_path;
    std::chrono::seconds ttl;
};

struct RecognizerConfig {
    std::string languageDictPath;
    std::string languageWeightsPath;
    std::string encodingDictPath;
};

struct AttachSidConfig {
    std::string aesKeysPath;
    std::string hmacKeysPath;
};

struct Config {
    std::string profiler_log_name;
    std::string web_server_module;
    std::string mime_aliases;
    retriever::MulcagateConfig mulcagate;
    std::string mime_types;
    std::string libmagic_issues;
    std::string magic_file;
    std::string uatraits_config;
    std::string uatraits_profiles_config;
    retriever::HoundConfig hound;
    std::size_t max_parallel_io_count;
    std::chrono::milliseconds max_parallel_io_wait_duration;
    std::size_t coroutine_stack_size;
    retriever::ResizeConfig resize;
    retriever::MulcagateUrlConfig mulcagate_url;
    retriever::RecognizerConfig recognizer;
    retriever::AttachSidConfig attach_sid_keys;
    std::string tvm_module;
};

} // namespace retriever

YREFLECTION_ADAPT_ADT(retriever::MulcagateConfig,
    YREFLECTION_WO_MEMBER(std::string, cluster_client_module)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, storage_name_space, settings->storageNameSpace)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, service, settings->service)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, connect_timeout_ms, settings->connectTimeoutMs)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, get_timeout_ms, settings->getTimeoutMs)
    YREFLECTION_WO_MEMBER_RENAMED(unsigned, put_timeout_ms, settings->putTimeoutMs)
    YREFLECTION_WO_MEMBER_RENAMED(bool, keep_alive, settings->keepAlive)
)

YREFLECTION_ADAPT_ADT(retriever::MulcagateUrlConfig,
    YREFLECTION_WO_MEMBER(std::string, host)
    YREFLECTION_WO_MEMBER(std::uint16_t, port)
    YREFLECTION_WO_MEMBER(std::string, key_path)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, ttl_s, std::chrono::seconds, ttl)
)

YREFLECTION_ADAPT_ADT(retriever::RecognizerConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, language_dict, languageDictPath)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, language_weights, languageWeightsPath)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, encoding_dict, encodingDictPath)
)

YREFLECTION_ADAPT_ADT(retriever::AttachSidConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, aes_keys, aesKeysPath)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, hmac_keys, hmacKeysPath)
)

YREFLECTION_ADAPT_ADT(retriever::Config,
    YREFLECTION_WO_MEMBER(std::string, profiler_log_name)
    YREFLECTION_WO_MEMBER(std::string, web_server_module)
    YREFLECTION_WO_MEMBER(std::string, tvm_module)
    YREFLECTION_WO_MEMBER(std::string, mime_aliases)
    YREFLECTION_WO_MEMBER(retriever::MulcagateConfig, mulcagate)
    YREFLECTION_WO_MEMBER(std::string, mime_types)
    YREFLECTION_WO_MEMBER(std::string, libmagic_issues)
    YREFLECTION_WO_MEMBER(std::string, magic_file)
    YREFLECTION_WO_MEMBER(std::string, uatraits_config)
    YREFLECTION_WO_MEMBER(std::string, uatraits_profiles_config)
    YREFLECTION_WO_MEMBER(retriever::HoundConfig, hound)
    YREFLECTION_WO_MEMBER(std::size_t, max_parallel_io_count)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, max_parallel_io_wait_duration_ms, std::chrono::milliseconds, max_parallel_io_wait_duration)
    YREFLECTION_WO_MEMBER(std::size_t, coroutine_stack_size)
    YREFLECTION_WO_MEMBER(retriever::ResizeConfig, resize)
    YREFLECTION_WO_MEMBER(retriever::MulcagateUrlConfig, mulcagate_url)
    YREFLECTION_WO_MEMBER(retriever::RecognizerConfig, recognizer)
    YREFLECTION_WO_MEMBER(retriever::AttachSidConfig, attach_sid_keys)
)
