#pragma once


#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wold-style-cast"
#pragma clang diagnostic ignored "-Wsign-conversion"
#pragma clang diagnostic ignored "-Wshorten-64-to-32"
#include <src/log.hpp>
#include <yplatform/find.h>
#include <ymod_httpclient/call.h>
#pragma clang diagnostic pop

#include <memory>

namespace retriever {

template <typename T>
auto makeGetHttpClient(const std::string& httpModuleName) {
    auto httpModule = yplatform::find<T, std::shared_ptr>(httpModuleName);
    if (!httpModule) {
        LOGDOG_(makeLoggerWithRequestId(""), error, logdog::message="cannot get http '" + httpModuleName + "' module");
        throw std::runtime_error("cannot get http '" + httpModuleName + "' module");
    }

    return [httpModule]() { return httpModule; };
}

inline auto makeGetHttpClient(const std::string& httpModuleName) {
    return makeGetHttpClient<yhttp::simple_call>(httpModuleName);
}

inline auto makeGetClusterClient(const std::string& httpModuleName) {
    return makeGetHttpClient<ymod_httpclient::cluster_call>(httpModuleName);
}

using GetHttpClient = std::function<std::shared_ptr<yhttp::simple_call>()>;
using GetClusterClient = std::function<std::shared_ptr<ymod_httpclient::cluster_call>()>;

} // namespace retriever
