#pragma once

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wold-style-cast"
#pragma clang diagnostic ignored "-Wsign-conversion"
#pragma clang diagnostic ignored "-Wcast-qual"
#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>
#pragma clang diagnostic pop

#include <src/task_context.hpp>
#include <src/log.hpp>

namespace retriever {

template <class Tvm>
auto makeGetServiceTicket(Tvm tvm) {
    return [tvm] (const std::string &service, const std::string& requestId) {
        std::string ticket;
        if (auto ec = tvm->get_service_ticket(service, ticket)) {
            LOGDOG_(makeLoggerWithRequestId(requestId), error,
                logdog::message="cannot get '" + service + "' service ticket", logdog::error_code=ec);
            throw std::runtime_error("cannot get '" + service + "' service ticket: " + ec.message());
        }
        return ticket;
    };
}

using GetServiceTicket = std::function<std::string(const std::string& service, const std::string& requestId)>;

} // namespace retriever
