#pragma once

#include <yplatform/log.h>

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>

namespace retriever::log {

LOGDOG_DEFINE_ATTRIBUTE(std::string, stid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, hid)
LOGDOG_DEFINE_ATTRIBUTE(std::string, mid)

constexpr static auto retriever_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-retriever-tskv-log"));

} // namespace retriever::log

inline auto makeLogger() {
    return logdog::make_log(
        ::retriever::log::retriever_formatter,
        yplatform::log::source {YGLOBAL_LOG_SERVICE, "retriever"}
    );
}

inline auto makeLoggerWithRequestId(const std::string& requestId) {
    return logdog::bind(makeLogger(), logdog::request_id = requestId);
}

using Logger = decltype(makeLoggerWithRequestId(""));
