#include <iostream>
#include <algorithm>
#include <iterator>

#include <butil/butil.h>

#include <stdexcept>

#include <src/logic/message_part_real/cm_config.hpp>

#undef SHOW_DEBUG
#define SHOW_DEBUG(n)

using namespace std;

namespace retriever {

Config::Config(const string& cookie)
{
	dummy_.blockNo = 0;
	//dummy_.data.push_back(0);
	if(cookie.empty()){
		CreateDefaultConfig();
	}
	else{
		try {
			ParseCookie(cookie);
		}
		catch (std::runtime_error& e) {
			SHOW_DEBUG("Got runtime error: " << e.what() << "\n");
			CreateDefaultConfig();
		}
	}
};

bool
Config::push_back(unsigned int columnNo, const BlockSetup& s)
{
	if (data_.size() <= columnNo) {
		data_.resize(columnNo+1);
	}
	ColumnSetup &cs = data_[columnNo];
	cs[s.blockNo] = s;
	return true;
};

BlockSetup*
Config::find(unsigned int columnNo, BlockNo blockNo)
{
	// FIXME
	if(data_.size() <= columnNo) {
		return &dummy_;
	}

	ColumnSetup &cs = data_[columnNo];
	BlockSetup &bs = cs[blockNo];
	return &bs;
};

std::string
Config::ToString()
{

	std::string rv;

	//SHOW_DEBUG( endl << "Marshaling setup..." << endl);
	rv.push_back('c');
	for(size_t i = 0; i!=data_.size(); ++i){
		//SHOW_DEBUG( "Marshaling column " << i << endl);
		//rv.push_back(i);
		for(ColumnSetup::const_iterator j = data_[i].begin(); j != data_[i].end(); ++j){
			//SHOW_DEBUG( "Marshaling block " << j->first << endl);
            rv.push_back(char(j->first));
			//SHOW_DEBUG( "Marshaling " << j->second.data.size() << " fields" << endl);
            rv.push_back(char(j->second.data.size()));

			for(size_t k=0; k<j->second.data.size(); ++k){
				unsigned int value = j->second.data[k];
				if(value < 0x80){
					//SHOW_DEBUG( "Marshaling 1 byte " << value << endl);
                    rv.push_back(char(value));
				}
				else if(value < 0x4000){
					//SHOW_DEBUG( "Marshaling 2 bytes " << value << endl);
					value |= 0x8000;
					unsigned int c = value & 0xFF;
					value >>= 8;
					SHOW_DEBUG( (int)c << " " << value << endl);
                    rv.push_back(char(value));
                    rv.push_back(char(c));
				}
				else if(value < 0x10000000){
					//SHOW_DEBUG( "Marshaling 4 bytes " << value << endl);
					value |= 0xE0000000;
					unsigned char c1, c2, c3, c4;

					c1 = static_cast<unsigned char>(value % 0x100);
					value /= 0x100;

					c2 = static_cast<unsigned char>(value % 0x100);
					value /= 0x100;

					c3 = static_cast<unsigned char>(value % 0x100);
                    c4 = static_cast<unsigned char>(value /= 0x100);

					//SHOW_DEBUG( "Marshaling 4 bytes "
					//		<< int(c4) << " "
					//		<< int(c3) << " "
					//		<< int(c2) << " "
					//		<< int(c1) << " " << endl);
#if 0
					rv.push_back(c1);
					rv.push_back(c2);
					rv.push_back(c3);
					rv.push_back(c4);
#else
					rv.push_back(c4);
					rv.push_back(c3);
					rv.push_back(c2);
					rv.push_back(c1);
#endif
				}
				else{
					throw(runtime_error("Can't marshal setup!"));
				}
			}
			//rv.push_back(j->second.bits);
		}
		rv.push_back(0);
	}

	return encode_base64(rv);
}

#define CHECK_ITERATOR(i) if((i)==bend) return;

void
Config::ParseCookie(const std::string& cookie)
{
	std::string bytes = decode_base64(decode_url(cookie));

	//SHOW_DEBUG("Got " << bytes.size() << " bytes form cookie " << cookie << endl);
	//SHOW_DEBUG("Version " << bytes[1] << "\n");

	if(bytes[0] != 'c'){
		throw(std::runtime_error("Wrong cookie version!"));
	}
    std::string::iterator i = bytes.begin();
    std::string::iterator bend = bytes.end();
	CHECK_ITERATOR(i);
	++i;
	CHECK_ITERATOR(i);

	unsigned int columnNo = 0;
	BlockNo blockNo;
	while(i!=bytes.end()){
		blockNo = *i;
		++i;

		SHOW_DEBUG("Got BlockID " << (blockNo) << endl);
		if(blockNo == 0){
			// HACK HACK HACK
			return;
			++columnNo;
		}
		else{
			CHECK_ITERATOR(i);
			unsigned char blockSetupCount = *i;
			++i;
			//SHOW_DEBUG("Got " << (unsigned int)blockSetupCount << " fields" << endl);

			BlockSetup s;
			s.blockNo = blockNo;
			for(unsigned int k=0; k<blockSetupCount; ++k){
				CHECK_ITERATOR(i);
                unsigned int value = static_cast<unsigned char>(*i++);

				if(value < 0x80){
					SHOW_DEBUG("Unpack 1 byte" << endl);
				}
				else if(value < 0xC0){
                    SHOW_DEBUG("Unpack 2 byte " << (unsigned int)value << " " << (int)(unsigned char)*i << endl);
					CHECK_ITERATOR(i);
                    value = value*256 + static_cast<unsigned char>(*i++);
					value &= 0x3FFF;
				}
				else if(value < 0xF0){
					SHOW_DEBUG("Unpack 4 byte " << (unsigned int)value << " " << (int)(unsigned char)*i << endl);
					CHECK_ITERATOR(i);
                    value = value*256 + static_cast<unsigned char>(*i++);
					CHECK_ITERATOR(i);
                    value = value*256 + static_cast<unsigned char>(*i++);
					CHECK_ITERATOR(i);
                    value = value*256 + static_cast<unsigned char>(*i++);
					SHOW_DEBUG("Got value: " << value << endl);
					value &= 0xFFFFFFF;
				}
				else{
					SHOW_DEBUG( "Got some shit..." << value << endl);
					throw(runtime_error("Got some shit"));
				}
				s.data.push_back(value);

				SHOW_DEBUG("Got value: " << value << endl);
			}
			push_back(columnNo, s);
		}
	};
}

void
Config::CreateDefaultConfig()
{
	SHOW_DEBUG("CreateDefaultConfig\n");

#if 0
	Config& c = *this;
	{
		yandex::cm::BlockSetup s;
		s.blockNo = 1;
		s.data.push_back(0);
		s.data.push_back(0);

		c.push_back(0, s);
	}
	{
		yandex::cm::BlockSetup s;
		s.blockNo = 8;
		s.data.push_back(133);

		c.push_back(0, s);
	}

	{
		yandex::cm::BlockSetup s;
		s.blockNo = 12;
		s.data.push_back(128);
		s.data.push_back(0);

		c.push_back(0, s);
	}

	{
		yandex::cm::BlockSetup s;
		s.blockNo = 7;
		s.data.push_back(128);
		s.data.push_back(1);
		s.data.push_back(23);

		c.push_back(0, s);
	}

	{
		yandex::cm::BlockSetup s;
		s.blockNo = 21;
		s.data.push_back(128);
		s.data.push_back(1);
		s.data.push_back(2);
		s.data.push_back(4);
		s.data.push_back(5);
		s.data.push_back(235);
		s.data.push_back(10006);

		c.push_back(0, s);
	}
#endif
};

};
