#pragma once

#include <boost/utility.hpp>

#include <string>
#include <vector>
#include <map>

namespace retriever {

typedef unsigned int BlockNo;

struct BlockSetup {
    // typedef unsigned char Byte;
    typedef std::vector<unsigned int> Data;
    BlockSetup() : blockNo(0) {
    }
    BlockNo blockNo;
    Data data;
};

class Config : private boost::noncopyable {
public:
    typedef std::map<BlockNo, BlockSetup> ColumnSetup;
    typedef std::vector<ColumnSetup> Data;

    Config() {}
    Config(const std::string& str);
    ~Config() {}

    bool push_back(unsigned int columnNo, const BlockSetup& s);
    BlockSetup* find(unsigned int columnNo, BlockNo blockNo);

    std::string ToString();
    void CreateDefaultConfig();

private:
    Data data_;
    BlockSetup dummy_;
    void ParseCookie(const std::string& cookie);
};

} // retriever
