#include <src/logic/message_part_real/image_size.hpp>
#include <sstream>
#include <stdexcept>

namespace retriever {
namespace {

template <char Char>
std::istream& expect(std::istream& stream) {
    if (stream.peek() == Char) {
        stream.ignore();
    } else {
        stream.setstate(std::ios_base::failbit);
    }
    return stream;
}

} // namespace

ImageSize parseImageSize(const std::string& value) {
    std::istringstream stream(value);
    std::int32_t width;
    std::int32_t height;
    stream >> width >> expect<'x'> >> height;
    if (stream.fail() || width < 0 || height < 0) {
        throw std::runtime_error("failed to parse image size");
    }
    ImageSize result;
    result.width = std::uint32_t(width);
    result.height = std::uint32_t(height);
    return result;
}

} // namespace retriever
