#include <src/logic/message_part_real/cm_config.hpp>
#include <src/logic/message_part_real/language.hpp>
#include <butil/StrUtils/ToLower.h>
#include <boost/algorithm/string.hpp>
#include <boost/bind.hpp>
#include <algorithm>
#include <cstdlib>

namespace retriever {

bool cmpAcceptLangs(const AcceptLangItem & it1, const AcceptLangItem& it2) {
    return it1.second > it2.second;
}

std::size_t parseAcceptLanguage ( const std::string & acceptLanguage, std::vector<AcceptLangItem> & langs ) {
    std::size_t startIdx = 0;
    std::size_t endIdx = 0;

    while ( endIdx <= acceptLanguage.size() ) {
        if ( ( acceptLanguage[endIdx] == ',' ) || ( endIdx == acceptLanguage.size() ) ) {
            std::string lang = acceptLanguage.substr( startIdx , endIdx - startIdx );
            std::size_t pos = 0;
            if ( ( pos = lang.find ( ';' ) ) == std::string::npos ) {
                langs.push_back ( AcceptLangItem ( lang,  1.0 ) );
            } else {
                langs.push_back ( AcceptLangItem ( lang.substr( 0 , pos) ,  atof ( lang.substr( pos + 3, lang.size() - pos + 3 ).c_str() ) ) );
            }
            startIdx = endIdx + 1;
        }
        endIdx++;
    }
    if ( !langs.size() ) {
        return 0;
    }

    std::sort ( langs.begin() , langs.end() , cmpAcceptLangs );

    return langs.size();
};


const char* LangChooser::langCode2Name(unsigned int langCode) {
    if (!isLangDefined(langCode)) {
        langCode = LAST;
    }
    Lang lang = static_cast<Lang>(langCode);
    switch (lang) {
        case AUTO: {return "auto";} break;
        case RU: {return "ru";} break;
        case UK: {return "uk";} break;
        case EN: {return "en";} break;
        case KK: {return "kk";} break;
        case BE: {return "be";} break;
        case TT: {return "tt";} break;
        case AZ: {return "az";} break;
        case TR: {return "tr";} break;
        default: {return "unknown";} break;
    };
}

unsigned int LangChooser::getLangCode(const std::string myCookieStr) {
    // see http://wiki.yandex-team.ru/MyCookie/NomerBloka
    const unsigned int LANG_BLOCK_NUM = 39;
    const unsigned int FAKE_COLUMN_NUM = 0;
    Config myCookieParser(myCookieStr);
    BlockSetup* block = myCookieParser.find(FAKE_COLUMN_NUM, LANG_BLOCK_NUM);
    if (NULL != block && block->data.size()>=2) {
        return block->data[1];
    }
    return 0;
}

bool compare(const AcceptLangItem& item, const LangChooser::Lang& language) {
    return boost::algorithm::iequals(item.first, LangChooser::langCode2Name(language));
}

bool languageAccepted(const std::string& acceptLanguageHeader, LangChooser::Lang language) {
    std::vector<AcceptLangItem> langs;
    parseAcceptLanguage(acceptLanguageHeader, langs);
    return std::find_if(langs.begin(), langs.end(), boost::bind(&compare, _1, language)) != langs.end();
}

} // namespace retriever
