#pragma once

#include <string>
#include <vector>

namespace retriever {

typedef std::pair<std::string, double> AcceptLangItem;

std::size_t parseAcceptLanguage(const std::string& acceptLanguage, std::vector<AcceptLangItem>& langs);

class LangChooser {
public:
    enum Lang {
        AUTO = 0,
        RU,
        UK,
        EN,
        KK,
        BE,
        TT,
        AZ,
        TR,
        LAST
    };
public:
    static inline bool isLangDefined(unsigned int langCode) {
        return langCode < LAST && AUTO != langCode;
    }
    static const char* langCode2Name(unsigned int langCode);
    static unsigned int getLangCode(const std::string myCookieStr);
};

bool languageAccepted(const std::string& acceptLanguageHeader, LangChooser::Lang language);

} // namespace retriever
