#pragma once

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wold-style-cast"
#include <mail_getter/service.h>
#pragma clang diagnostic pop

#include <src/services/hound/hound_client.hpp>
#include <src/logic/message_part_real/message_part.hpp>
#include <mail_getter/part_id.h>
#include <boost/variant/static_visitor.hpp>
#include <unordered_set>
#include <unordered_map>

namespace retriever {

using Attach = MessagePart;
using mail_getter::Stid;
using mail_getter::Hid;
using StorageServicePtr = mail_getter::ServicePtr;
using MakeMessageAccess = std::function<MessageAccessPtr (Stid, macs::MimeParts, StorageServicePtr,
                                                          const Recognizer::Wrapper&, YieldContext)>;

struct NoMessageParts : public std::runtime_error {
    using std::runtime_error::runtime_error;
};

MessageAccessPtr makeDefaultMessageAccess(Stid stid, macs::MimeParts, StorageServicePtr storageService,
                                          const Recognizer::Wrapper& recognizer, YieldContext yc);

class MakeAttach : public boost::static_visitor<Attach> {
public:
    MakeAttach(TaskContextPtr context, StorageServicePtr storageService, HoundClientPtr houndClient,
               const Recognizer::Wrapper& recognizer,
               boost::optional<std::string> zipArchiveEncoding = boost::none,
               MakeMessageAccess makeMessageAccess = makeDefaultMessageAccess);

    Attach operator ()(const mail_getter::part_id::Old& partId) const;
    Attach operator ()(const mail_getter::part_id::Temporary& partId) const;
    Attach operator ()(const mail_getter::part_id::SingleMessagePart& partId) const;
    Attach operator ()(const mail_getter::part_id::MultipleMessagePart& partId) const;

private:
    TaskContextPtr context;
    StorageServicePtr storageService;
    HoundClientPtr houndClient;
    const Recognizer::Wrapper& recognizer;
    boost::optional<std::string> zipArchiveEncoding;
    MakeMessageAccess makeMessageAccess;

    hound::MessageParts getMessageParts(const Uid& uid, const Mid& mid) const;
};

} // namespace retriever
