#pragma once

#include <mail_getter/MessageAccessDefinitions.h>
#include <string>

namespace retriever {

struct MessagePart {
    std::string content;
    std::string filename;
    std::string type;
    std::string subtype;
    std::string charset;
    std::string stid;
    std::size_t offsetBegin;
    std::size_t offsetEnd;
};

MessagePart makeMessagePart(std::string stid, std::string body, const MetaPart& attributes);

std::string make_content_type(const std::string& filename,
                              const std::string& type,
                              const std::string& subtype,
                              const std::string& charset);

struct ZipArchive {
    std::string content;
    std::string type;
    std::string subtype;
};

std::vector<std::string> parseMultiHid(const std::string& hid);
ZipArchive create_zip_archive(const std::string& encoding, std::vector<MessagePart> messageParts);

} // namespace retriever
