#include <src/logic/message_part_real/resizer.hpp>

#include <yplatform/encoding/url_encode.h>

namespace retriever {

Resizer::Resizer() {
    params.width = std::numeric_limits<std::uint32_t>::max();
    params.height = std::numeric_limits<std::uint32_t>::max();
}

Resizer& Resizer::exifRotate(bool value) {
    params.noautoorient = !value;
    return *this;
}

Resizer& Resizer::cropRect(bool value) {
    params.crop = value;
    return *this;
}

Resizer& Resizer::size(const ImageSize& value) {
    params.width = value.width;
    params.height = value.height;
    return *this;
}

Resizer& Resizer::attachment(const std::string& fileName) {
    attachmentFileName = fileName;
    return *this;
}

Resizer& Resizer::fromBase64(bool value) {
    fromBase64_ = value;
    return *this;
}

std::string Resizer::genurl(const TaskContextPtr& context, const std::string& imageUrl, const ResizeClient& resizeClient) const {
    auto paramsCopy = params;
    paramsCopy.url = imageUrl;
    auto url = resizeClient.genurl(context, paramsCopy);
    if (attachmentFileName) {
        url += "&attachment=";
        const auto attachment = yplatform::url_encode(attachmentFileName.get());
        url += std::string(attachment.begin(), attachment.end());
    }
    if (fromBase64_ && fromBase64_.get()) {
        url += "&frombase64";
    }
    return url;
}

} // namespace retriever
