#pragma once

#include <src/services/resize/resize_client.hpp>
#include <src/logic/message_part_real/image_size.hpp>

namespace retriever {

class Resizer {
public:
    Resizer();

    Resizer& exifRotate(bool value);
    Resizer& cropRect(bool value);
    Resizer& size(const ImageSize& value);
    Resizer& attachment(const std::string& fileName);
    Resizer& fromBase64(bool value);

    std::string genurl(const TaskContextPtr& context, const std::string& imageUrl, const ResizeClient& resizeClient) const;

private:
    ResizeClient::GenurlParams params;
    boost::optional<std::string> attachmentFileName;
    boost::optional<bool> fromBase64_;
};

} // namespace retriever
