#include "signed_mulcagate_url_generator.hpp"

#include <yplatform/encoding/url_encode.h>

#include <butil/crypt.h>

#include <boost/algorithm/hex.hpp>

#include <sstream>

namespace retriever {

SignedMulcagateUrlGenerator::SignedMulcagateUrlGenerator(const std::string& mulcagateLocation, const std::string& mulcagateService,
        const std::string& mulcagateKey, std::chrono::seconds mulcagateUrlTtl)
    : mulcagateLocation(mulcagateLocation),
      mulcagateService(mulcagateService),
      mulcagateKey(mulcagateKey),
      mulcagateUrlTtl(mulcagateUrlTtl) {
}

std::string SignedMulcagateUrlGenerator::generate(const std::string& stid, std::size_t offset, std::size_t length) const {
    std::ostringstream tsHex;
    const auto time = std::time(nullptr);
    const auto ts = time + std::min(
        std::numeric_limits<std::time_t>::max() - time,
        static_cast<std::time_t>(mulcagateUrlTtl.count())
    );
    tsHex << std::hex << ts;
    std::string sign;
    boost::algorithm::hex_lower(::crypto::hmac(stid + "/" + tsHex.str(), mulcagateKey), std::back_inserter(sign));
    std::ostringstream url;
    url << mulcagateLocation
        << "/gate/mail/" << stid
        << "?sign=" << sign
        << "&ts=" << tsHex.str()
        << "&service=" << yplatform::url_encode(mulcagateService)
        << "&offset=" << offset
        << "&length=" << length;
    return url.str();
}

} // namespace retriever
