#pragma once

#include <chrono>
#include <string>

namespace retriever {

class SignedMulcagateUrlGenerator {
public:
    SignedMulcagateUrlGenerator(const std::string& mulcagateLocation, const std::string& mulcagateService,
        const std::string& mulcagateKey, std::chrono::seconds mulcagateUrlTtl);

    std::string generate(const std::string& stid, std::size_t offset, std::size_t length) const;

private:
    std::string mulcagateLocation;
    std::string mulcagateService;
    std::string mulcagateKey;
    std::chrono::seconds mulcagateUrlTtl;
};

} // namespace retriever
