#include <src/module.hpp>
#include <src/server/bind_handlers.hpp>
#include <yplatform/module_registration.h>
#include <yplatform/find.h>

#include <yamail/data/deserialization/ptree.h>
#include <yamail/data/serialization/ptree.h>

#include <pa/async.h>

BOOST_FUSION_ADAPT_STRUCT(yamail::resource_pool::async::stats,
    size,
    available,
    used,
    queue_size
)

BOOST_FUSION_ADAPT_STRUCT(retriever::MessagePartReal::Stats,
    pool
)

BOOST_FUSION_DEFINE_STRUCT((retriever), Stats,
    (retriever::MessagePartReal::Stats, message_part_real)
)

namespace retriever {
namespace {

void initializePa(const std::string& logPath) {
    if (!pa::async_profiler::is_init()) {
        pa::async_profiler::init(1000000, 16000, logPath);
    }
}

} // namespace

void Module::init(const yplatform::ptree& data) {
    using yamail::data::deserialization::fromPtree;
    const auto config = fromPtree<Config>(data);
    initializePa(config.profiler_log_name);
    const auto server = yplatform::find<ymod_webserver::server, std::shared_ptr>(config.web_server_module);
    messagePartReal = makeMessagePartReal(config);
    bindHandlers(*server, config, messagePartReal);
}

yplatform::ptree Module::get_stats() const {
    using yamail::data::serialization::toPtree;
    Stats result;
    result.message_part_real = messagePartReal->getStats();
    return toPtree(result);
}

} // namespace retriever

DEFINE_SERVICE_OBJECT(retriever::Module)
