#pragma once

#include <src/logic/message_part_real/message_part_real.hpp>
#include <ymod_webserver/response.h>
#include <src/log.hpp>

namespace retriever {

Parameters makeParameters(const ymod_webserver::http::stream& stream);

static const std::string empty;

template <class Map>
inline const std::string& getOrEmpty(const Map& map, const std::string& key) {
    const auto it = map.find(key);
    return it == map.end() ? empty : it->second;
}

class Response : public boost::static_visitor<> {
public:
    Response(const ymod_webserver::http::stream_ptr& stream, const Logger& logger)
        : stream(stream), logger(logger) {}

    void operator ()(const Content& value) const;
    void operator ()(const ErrorCode& value) const;

private:
    const ymod_webserver::http::stream_ptr& stream;
    const Logger& logger;
};

inline auto makeMessagePartRealHandler(std::shared_ptr<MessagePartReal> impl) {
    using ymod_webserver::http::stream_ptr;
    return [impl = std::move(impl)]
        (const TaskContextPtr& context, const Logger& logger, const stream_ptr& stream) mutable {
            const auto result = impl->handle(context, logger, makeParameters(*stream));
            return boost::apply_visitor(Response(stream, logger), result);
        };
}

} // namespace retriever
