#pragma once

#include <src/task_context.hpp>
#include <src/get_http_client.hpp>
#include <src/get_tvm_client.hpp>
#include <src/services/hound/reflection/mimes.hpp>
#include <ymod_httpclient/call.h>
#include <macs/types.h>
#include <yplatform/time_traits.h>
#include <boost/optional.hpp>

namespace retriever {

using macs::Uid;
using macs::Mid;
using OptMessageParts = boost::optional<hound::MessageParts>;

struct HoundClient {
    virtual ~HoundClient() = default;

    virtual OptMessageParts getMessageParts(TaskContextPtr context, const Uid& uid, const Mid& mid) const = 0;
};

class HoundClientImpl : public HoundClient {
public:
    using Duration = yplatform::time_traits::duration;
    using Timeouts = ymod_httpclient::timeouts;

    struct Config {
        std::string location;
        Timeouts timeouts;
        std::size_t retries;
        std::string service_name;
    };

    HoundClientImpl(GetHttpClient getHttpClient, GetServiceTicket getServiceTicket, Config config);

    OptMessageParts getMessageParts(TaskContextPtr context, const Uid& uid, const Mid& mid) const override final;

private:
    GetHttpClient getHttpClient;
    GetServiceTicket getServiceTicket;
    Config config;
};

using HoundClientPtr = std::shared_ptr<const HoundClient>;

} // namespace retriever
