#include <src/services/hound/hound_error.hpp>
#include <stdexcept>

namespace retriever {

bool isRetriableHoundError(HoundError value) {
    switch (value) {
        case HoundError::ok:
        case HoundError::dbReadOnly:
        case HoundError::dbUniqueConstraint:
        case HoundError::notInitialized:
        case HoundError::noSuchMessage:
        case HoundError::invalidArgument:
        case HoundError::noSuchFolder:
        case HoundError::noSuchLabel:
        case HoundError::folderNotEmpty:
        case HoundError::revisionNotFound:
        case HoundError::tooManyMessages:
        case HoundError::noSuchTab:
        case HoundError::emptyResult:
        case HoundError::uidNotFound:
            return false;

        case HoundError::unknown:
        case HoundError::internal:
        case HoundError::dbUnknownError:
        case HoundError::regInProgress:
        case HoundError::httpError:
        case HoundError::noContentType:
        case HoundError::invalidContentType:
        case HoundError::invalidMimeBody:
            return true;
    }
    return true;
}

} // namespace retriever
