#include <src/services/mulcagate/http.hpp>
#include <http_getter/http_request.h>

namespace retriever {

MulcagateHttpClient::MulcagateHttpClient(GetClusterClient getClusterClient, GetServiceTicket getServiceTicket)
    : getClusterClient(getClusterClient)
    , getServiceTicket(std::move(getServiceTicket)) {
}

void MulcagateHttpClient::aget(const BaseParams& params, Handler handler) const {
    using namespace http_getter;
    Request request = get(makeUrl(params))
        .headers(
            "hdrs"_hdr=params.headers,
            requestId=params.requestId,
            serviceTicket=getServiceTicket("mulcagate", params.requestId)
        )
        .getArgs("args"_arg=params.args)
        .keepAlive(params.keepAlive)
        .timeouts(params.timeout, params.connectTimeout)
        .make();

    aop(std::move(request), params.requestId, std::move(handler));
}

void MulcagateHttpClient::apost(const BaseParams& params, const std::string& data, Handler handler) const {
    using namespace http_getter;
    Request request = post(makeUrl(params))
        .headers(
            "hdrs"_hdr=params.headers,
            requestId=params.requestId,
            serviceTicket=getServiceTicket("mulcagate", params.requestId)
        )
        .getArgs("args"_arg=params.args)
        .keepAlive(params.keepAlive)
        .timeouts(params.timeout, params.connectTimeout)
        .body(data)
        .make();

    aop(std::move(request), params.requestId, std::move(handler));
}

void MulcagateHttpClient::aop(http_getter::Request&& request, const std::string& requestId, Handler&& handler) const {
    using namespace http_getter;
    asyncRun(
        *getClusterClient(),
        boost::make_shared<yplatform::task_context>(requestId),
        std::move(request),
        [handler = std::move(handler)](boost::system::error_code ec, yhttp::response response) {
            if (ec) {
                handler(mail_getter::error_code(ec), Response());
            } else {
                handler(mail_getter::error_code(), Response(unsigned(response.status), std::move(response.body)));
            }
        }
    );
}

std::string MulcagateHttpClient::makeUrl(const BaseParams& params) {
    return params.path;
}

} // namespace retriever
