#pragma once

#include <src/get_http_client.hpp>
#include <src/get_tvm_client.hpp>
#include <mail_getter/mulcagate/http.h>
#include <http_getter/http_request.h>

namespace retriever {

class MulcagateHttpClient : public mail_getter::mulcagate::http::HttpClient {
public:
    using Timeout = mail_getter::mulcagate::http::Timeout;
    using BaseParams = mail_getter::mulcagate::http::BaseParams;
    using Response = mail_getter::mulcagate::http::Response;
    using Handler = mail_getter::mulcagate::http::ResponseHandler;

    MulcagateHttpClient(GetClusterClient getClusterClient, GetServiceTicket getServiceTicket);

    void aget(const BaseParams& params, Handler handler) const override;
    void apost(const BaseParams& params, const std::string& data, Handler handler) const override;

private:
    GetClusterClient getClusterClient;
    GetServiceTicket getServiceTicket;

    void aop(http_getter::Request&& request, const std::string& requestId, Handler&& handler) const;

    static std::string makeUrl(const BaseParams& params);
};

} // namespace retriever
