#pragma once

#include <src/log.hpp>
#include <mail_getter/logging.h>

namespace retriever {

class MulcagateLog : public mail_getter::logging::Log {
public:
    using ServiceName = mail_getter::logging::ServiceName;
    using Message = mail_getter::logging::Message;

    MulcagateLog(const Logger& logger)
        : logger(logger) {}

    void warning(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, warning, logdog::where_name="mulcagate: " + name, logdog::message=msg);
    }

    void error(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, error, logdog::where_name="mulcagate: " + name, logdog::message=msg);
    }

    void notice(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, notice, logdog::where_name="mulcagate: " + name, logdog::message=msg);
    }

    void debug(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, debug, logdog::where_name="mulcagate: " + name, logdog::message=msg);
    }

private:
    Logger logger;
};

} // namespace retriever
