#pragma once

#include <src/task_context.hpp>

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wold-style-cast"
#include <boost/fusion/adapted/struct.hpp>
#pragma clang diagnostic pop

namespace retriever {

struct ResizeClient {
    struct GenurlParams {
        std::string url;
        boost::optional<std::uint32_t> width;
        boost::optional<std::uint32_t> height;
        boost::optional<bool> crop;
        boost::optional<bool> noautoorient;
    };

    struct Image {
        boost::optional<std::string> contentDisposition;
        boost::optional<std::string> contentType;
        std::string content;
    };

    virtual ~ResizeClient() = default;

    virtual std::string genurl(const TaskContextPtr& context, const GenurlParams& params) const = 0;
    virtual boost::optional<Image> get(const TaskContextPtr& context, std::string url) const = 0;
};

using ResizeClientPtr = std::shared_ptr<const ResizeClient>;

} // namespace retriever

BOOST_FUSION_ADAPT_STRUCT(retriever::ResizeClient::GenurlParams,
    (std::string, url)
    (boost::optional<std::uint32_t>, width)
    (boost::optional<std::uint32_t>, height)
    (boost::optional<bool>, crop)
    (boost::optional<bool>, noautoorient)
)
