#pragma once

#include <src/services/resize/resize_client.hpp>
#include <src/get_http_client.hpp>
#include <src/get_tvm_client.hpp>
#include <http_getter/http_request.h>

namespace retriever {

class ResizeClientImpl final : public ResizeClient {
public:
    using Timeouts = ymod_httpclient::timeouts;
    using Response = yhttp::response;

    struct Config {
        struct Genurl {
            std::string cluster_client_module;
        };

        struct Get {
            std::string http_client_module;

            std::string location;
            Timeouts timeouts;
            std::size_t retries;
        };

        Genurl genurl;
        Get get;
    };

    ResizeClientImpl(GetClusterClient getGenurlClusterClient,
                     GetHttpClient getGetHttpClient,
                     GetServiceTicket getServiceTicket,
                     Config config);

    std::string genurl(const TaskContextPtr& context, const GenurlParams& params) const override;
    boost::optional<Image> get(const TaskContextPtr& context, std::string url) const override;

private:
    using Request = http_getter::Request;

    GetClusterClient getGenurlClusterClient;
    GetHttpClient getGetHttpClient;

    GetServiceTicket getServiceTicket;
    Config config;

    std::optional<Response> performWithClusterClient(http_getter::Request&& request,
                                                     const TaskContextPtr& context) const;

    std::optional<Response> performWithHttpClient(http_getter::Request&& request,
                                                  const TaskContextPtr& context,
                                                  std::size_t retries) const;
};

} // namespace retriever
