#pragma once

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wold-style-cast"
#include <yplatform/encoding/url_encode.h>
#include <yamail/data/reflection/tag.h>
#include <yamail/data/reflection/visitor.h>
#pragma clang diagnostic pop

#include <type_traits>

namespace retriever {

class ResizeParamsWriter {
public:
    template <class T>
    using EnableIfIsBool = std::enable_if_t<std::is_same<std::decay_t<T>, bool>::value>;

    template <class T>
    using EnableIfIsString = std::enable_if_t<std::is_same<std::decay_t<T>, std::string>::value>;

    template <class T>
    using EnableIfIsNotBoolAndNotString = std::enable_if_t<!std::is_same<std::decay_t<T>, bool>::value
                                                           && !std::is_same<std::decay_t<T>, std::string>::value>;

    template <class ... Args>
    using NamedItemTag = yamail::data::reflection::NamedItemTag<Args ...>;

    using Visitor = yamail::data::reflection::Visitor;

    ResizeParamsWriter(std::ostream& stream)
            : stream(&stream) {
    }

    template <class Value, class ... Args>
    EnableIfIsBool<Value> onValue(Value&& value, NamedItemTag<Args...> tag) {
        writeSeparator();
        *stream << yamail::data::reflection::name(tag) << "=" << (value ? "yes" : "no");
    }

    template <class Value, class ... Args>
    EnableIfIsString<Value> onValue(Value&& value, NamedItemTag<Args...> tag) {
        writeSeparator();
        *stream << yamail::data::reflection::name(tag) << "=" << yplatform::url_encode(value);
    }

    template <class Value, class ... Args>
    EnableIfIsNotBoolAndNotString<Value> onValue(Value&& value, NamedItemTag<Args...> tag) {
        writeSeparator();
        *stream << yamail::data::reflection::name(tag) << "=" << value;
    }

    template <class Struct, class Tag>
    ResizeParamsWriter onStructStart(Struct&&, Tag) {
        return *this;
    }

    template <class Struct, class Tag>
    void onStructEnd(Struct&&, Tag) {}

    template <class Map, class ... Args>
    Visitor onMapStart(Map&&, NamedItemTag<Args...>) {
        return Visitor();
    }

    template <class Map, class Tag>
    void onMapEnd(Map&& , Tag) {}

    template <class Sequence, class Tag>
    Visitor onSequenceStart(Sequence&& , Tag) {
        return Visitor();
    }

    template <class Sequence, class Tag>
    void onSequenceEnd(Sequence&& , Tag) {}

    template <class Optional, class Tag>
    bool onOptional(Optional&& value, Tag) {
        return value.is_initialized();
    }

    template <class Pointer, class Tag>
    bool onSmartPointer(Pointer&& value, Tag) {
        return value.get();
    }

    template <class Ptree, class Tag>
    void onPtree(Ptree&&, Tag) {}

private:
    std::ostream* stream;
    bool isFirst = true;

    void writeSeparator() {
        if (isFirst) {
            isFirst = false;
        } else {
            *stream << '&';
        }
    }
};

} // namespace retriever
