#pragma once

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wold-style-cast"
#pragma clang diagnostic ignored "-Wsign-conversion"
#pragma clang diagnostic ignored "-Wshorten-64-to-32"
#include <yplatform/task_context.h>
#pragma clang diagnostic pop

#include <boost/asio/spawn.hpp>

namespace retriever {

using YieldContext = boost::asio::yield_context;

class TaskContext : public yplatform::task_context {
public:
    TaskContext(const std::string& uniqId, std::string requestId, YieldContext yieldContext)
        : yplatform::task_context(uniqId),
          requestId_(std::move(requestId)),
          yieldContext_(std::move(yieldContext)) {
    }

    const std::string& requestId() const {
        return requestId_;
    }

    const YieldContext& yieldContext() const {
        return yieldContext_;
    }

private:
    std::string requestId_;
    YieldContext yieldContext_;
};

using TaskContextPtr = boost::shared_ptr<TaskContext>;

} // namespace retriever
