from cpython cimport *


cdef extern from "mail/retriever/src/services/hound/hound_error.hpp" nogil:	
    cdef int HE_httpError           'retriever::HoundError::httpError'
    cdef int HE_noContentType       'retriever::HoundError::noContentType'
    cdef int HE_invalidContentType  'retriever::HoundError::invalidContentType'
    cdef int HE_invalidMimeBody     'retriever::HoundError::invalidMimeBody'


cdef class HoundError:
    httpError           = str(<int> HE_httpError)
    noContentType       = str(<int> HE_noContentType)
    invalidContentType  = str(<int> HE_invalidContentType)
    invalidMimeBody     = str(<int> HE_invalidMimeBody)




cdef extern from "mail/retriever/src/services/resize/resize_errors.hpp" nogil:
    cdef int RE_httpError           'retriever::ResizeError::httpError'
    cdef int RE_noContentType       'retriever::ResizeError::noContentType'
    cdef int RE_invalidContentType  'retriever::ResizeError::invalidContentType'


cdef class ResizeError:
    httpError           = str(<int> RE_httpError)
    noContentType       = str(<int> RE_noContentType)
    invalidContentType  = str(<int> RE_invalidContentType)




cdef extern from "mail/retriever/src/logic/message_part_real/message_part_errors.hpp" nogil:	
    cdef int MPE_emptySid           'retriever::MessagePartError::emptySid'
    cdef int MPE_invalidSid         'retriever::MessagePartError::invalidSid'
    cdef int MPE_oldSid             'retriever::MessagePartError::oldSid'
    cdef int MPE_illFormedSid       'retriever::MessagePartError::illFormedSid'
    cdef int MPE_expiredSid         'retriever::MessagePartError::expiredSid'
    cdef int MPE_invalidAesKeyId    'retriever::MessagePartError::invalidAesKeyId'
    cdef int MPE_invalidHmacKeyId   'retriever::MessagePartError::invalidHmacKeyId'
    cdef int MPE_decryptionError    'retriever::MessagePartError::decryptionError'
    cdef int MPE_notFound           'retriever::MessagePartError::notFound'


cdef class MessagePartError:
    emptySid            = str(<int> MPE_emptySid)
    invalidSid          = str(<int> MPE_invalidSid)
    oldSid              = str(<int> MPE_oldSid)
    illFormedSid        = str(<int> MPE_illFormedSid)
    expiredSid          = str(<int> MPE_expiredSid)
    invalidAesKeyId     = str(<int> MPE_invalidAesKeyId)
    invalidHmacKeyId    = str(<int> MPE_invalidHmacKeyId)
    decryptionError     = str(<int> MPE_decryptionError)
    notFound            = str(<int> MPE_notFound)
