#!/usr/bin/env/python3

import logging
import json
import re
import os

logger = logging.getLogger("gunicorn.error")

# TODO extract to a function
if "USE_LOCAL_REDIS" in os.environ:
    import redis

    redis_master = redis.Redis(host="127.0.0.1", password="sOmE_sEcUrE_pAsS")
    redis_slave = redis_master
else:
    import redis.sentinel

    hosts = ["man-ypg1kbbxv01pfmin.db.yandex.net", "sas-q1802yfsltym14p3.db.yandex.net"]
    password_path = "/root/.rtec-boards-redis.password"
    password = open(password_path).read().strip()
    sentinel = redis.sentinel.Sentinel([(h, 26379) for h in hosts], socket_timeout=0.5)
    redis_master = sentinel.master_for("rtec-boards", password=password)
    redis_slave = sentinel.slave_for("rtec-boards", password=password)


def application(env, start_response):
    command = get_command_from_env(env)
    # TODO if not command:
    result: dict = command["function"](**command["args"])
    start_response("200 OK", [("Content-type", "application/json")])
    return [bytes(json.dumps(result), "utf-8")]


def list_boards():
    # TODO extract name composition
    data = redis_slave.keys("boards.*")
    boards = [str(key).replace("boards.", "") for key in data]
    return {"boards": boards}


def get_board(auth, name):
    # TODO check auth
    # TODO extract name composition
    data = redis_slave.get("boards." + name)
    if data and data != "":
        data = json.loads(data)
    else:
        data = {}
    return {"name": name, "data": data}


def set_board(auth, name, data):
    # TODO check auth
    # TODO extract name composition
    redis_master.set("boards." + name, data)
    return {}


def get_command_from_env(env):
    method = get_method_from_env(env)
    path = get_path_from_env(env)
    auth = get_auth_from_env(env)
    body = get_body_from_env(env) if method == "POST" else ""
    return create_command(method + " " + path, auth, body)


def create_command(path, auth, body):
    found = re.search("GET /settings/?$", path)
    if found:
        return {"function": list_boards, "args": {}}

    found = re.search("GET /settings/board/([a-z0-9-]+)", path)
    if found:
        return {"function": get_board, "args": {"auth": auth, "name": found.group(1)}}

    found = re.search("POST /settings/board/([a-z0-9-]+)", path)
    if found:
        return {"function": set_board, "args": {"auth": auth, "name": found.group(1), "data": body}}

    return None


def get_method_from_env(env):
    return env["REQUEST_METHOD"]


def get_path_from_env(env):
    return env["PATH_INFO"]


def get_body_from_env(env):
    return json.loads(env["wsgi.input"].read())


def get_auth_from_env(env):
    if "HTTP_X_BOARD_AUTHORIZATION" in env:
        return json.loads(env["HTTP_X_BOARD_AUTHORIZATION"])
    return {}
