var globalRevision = 0;

function initPage() {
    $(document).keyup(function(e) {
        if (e.key === "Escape") {
            closeCardFrame();
        }
    });
}

async function load() {
    document.maskData = evalMaskData();
    var id = evalID();
    drawHeader(labelForID(id));
    $('#board-body').html($('#board-loading').html());
    document.cards = await loadBoardCards(queryForID(id));
    displayGrid(document.cards, schemaForID(id));
    drawStats(statsURLForID(id));
}

async function loadPullRequestStates(initialRevision, cards)
{
    let unread = await loadUnreadPullRequests();

    let cardIDs = cards.filter(card => {
        let prStatuses = ['inReview', 'inProgress'];
        return prStatuses.includes(card.status);
    }).map(card => {
        return card.id;
    });

    cardIDs.forEach(async cardID => {
        let prIDs = await loadPullRequests(cardID);
        prIDs.forEach(async prID => {
            let state = "unknown";
            if (unread.includes(prID)) {
                state = "unread";
            } else {
                state = await loadPullRequestState(prID);
                if (initialRevision != globalRevision) {
                    return;
                }
            }
            drawPullRequestForCard(prID, cardID, state);
        });
    });
}

async function loadSubtaskStates(initialRevision, cards) {
    var ids = cards.filter(card => {
        return card['type'] == 'project' && (card['status'] == 'inProgress' || card['status'] == 'backlog');
    }).map(card => {
        return card["id"];
    });

    ids.forEach(async cardID => {
        var subtasks = await loadSubtasks(cardID);
        if (initialRevision != globalRevision) {
            return;
        }
        var closed = 0;
        subtasks.forEach(async subtask => {
            if (subtask["status"] == "closed") closed += 1;
        });
        drawChildrenForCard(cardID, subtasks.length, closed);
    });
}

async function moveCard(key, targetColumn) {
    $('#board').html($('#board-updating').html());
    var success = await moveIssue(key, targetColumn);
    if (!success) {
        console.log("move", key, "to column", targetColumn, "failed");
        return;
    }
    $.each(document.cards, (_, card) => {
        if (card["id"] == key) {
            card["status"] = targetColumn;
            delete card["statusStartTime"];
            delete card["inStatusTime"];
            return false;
        }
    });
    displayGrid(document.cards, schemaForID(evalID()));
    console.log("card", key, "has been moved to column", targetColumn);
}

async function blockCard(key, reason) {
    $('#board').html($('#board-updating').html());
    let tag = tagFromBlockerName(reason);
    let success = await addTags(key, [tag]);
    if (!success) {
        console.log("add tag", tag, "to card", key, "failed");
        return;
    }
    $.each(document.cards, (_, card) => {
        if (card.id == key) {
            card.blockingReason = reason;
            return false;
        }
    });
    displayGrid(document.cards, schemaForID(evalID()));
}

async function removeBlockersFromCard(key) {
    $('#board').html($('#board-updating').html());
    var tagsToRemove = [];
    $.each(document.cards, (_, card) => {
        if (card.id == key) {
            tagsToRemove = card.tags.filter(tag => {
                return tagIsBlocker(tag);
            })
            return false;
        }
    });
    if (tagsToRemove.length > 0) {
        var success = await removeTags(key, tagsToRemove);
        if (!success) {
            console.log("remove tags", tagsToRemove, "from card", key, "failed");
            return;
        }
    }
    $.each(document.cards, (_, card) => {
        if (card.id == key) {
            delete card.blockingReason;
            return false;
        }
    });
    displayGrid(document.cards, schemaForID(evalID()));
}

async function displayGrid(cards, schema) {
    globalRevision += 1;
    var board = cardListToBoardRows(cards, makeGridFromSchema(schema));
    drawBoard(board);
    loadPullRequestStates(globalRevision, document.cards);
    loadSubtaskStates(globalRevision, document.cards);
}

function makeGridFromSchema(schema) {
    let grid = [];
    Object.assign(grid, schema);
    for (let i = 0; i < schema.length; i++) {
        let row = schema[i];
        let cols = row.cols;
        for (let j = 0; j < cols.length; j++) {
            cols[j].cards = [];
            if (cols[j].adjacentStatus != undefined) cols[j].adjacentCards = [];
            if (cols[j].limit == undefined) cols[j].limit = 0;
            if (cols[j].title == undefined) cols[j].title = cols[j].status;
        }
    }
    return grid;
}

function cardListToBoardRows(cards, grid) {
    $.each(cards, (_, card) => {
        var matched = false;
        $.each(grid, (i, row) => {
            if (row.types && !cardTypeMatches(card, row.types)) {
                return;
            }
            if (row.priorities && !cardPriorityMatches(card, row.priorities)) {
                return;
            }
            if (row.noTags && tagMatches(card, row.noTags)) {
                return;
            }
            if (row.tags && !tagMatches(card, row.tags)) {
                return;
            }
            if (row.queues && !queueMatches(card, row.queues)) {
                return;
            }
            if (row.components && !componentMatches(card, row.components)) {
                return;
            }
            if (row.parents && !parentIn(card, row.parents)) {
                return;
            }
            if (row.projectsOnly === true && !hasProject(card)) {
                return;
            }
            if (row.noSameQueueParents === true && hasSameQueueParent(card)) {
                matched = true;
                return;
            }
            let colIndex = findColumnForCard(row, card);
            if (colIndex == -1) return;
            attachCard(row.cols[colIndex], card);
            matched = true;
            return false;
        });
        if (!matched) {
            console.log("no match for", card);
        }
    });
    return grid;
}

function findColumnForCard(gridRow, card) {
    for (var i = 0; i < gridRow.cols.length; i++) {
        let col = gridRow.cols[i];
        if (col.matchAll === true) {
            return i;
        }
        if (card.status && (col.status || col.adjacentStatus)) {
            if (col.status === card.status || col.adjacentStatus === card.status) return i;
        }
    }
    return -1;
}

function cardTypeMatches(card, types) {
    var result = false;
    $.each(types, (_, type) => {
        if (type == card["type"]) {
            result = true;
            return false;
        }
    });
    return result;
}

function parentIn(card, parents) {
    var result = false;
    $.each(parents, (_, parent) => {
        if (card.parent && parent == card.parent.id) {
            result = true;
            return false;
        }
    });
    return result;
}

function cardPriorityMatches(card, priorities) {
    var result = false;
    $.each(priorities, (_, priority) => {
        if (priority == card["priority"]) {
            result = true;
            return false;
        }
    });
    return result;
}

function tagMatches(card, tags) {
    var result = false;
    $.each(tags, (_, tag) => {
        if (card.tags && card.tags.includes(tag)) {
            result = true;
            return false;
        }
    });
    return result;
}

function queueMatches(card, queues) {
    var result = false;
    return queues.includes(card.queue);
}

function componentMatches(card, components) {
    var result = false;
    $.each(components, (_, component) => {
        if (card.components && card.components.includes(component)) {
            result = true;
            return false;
        }
    });
    return result;
}

function hasSameQueueParent(card) {
    return card.parent && card.parent.id && card.parent.id.includes(card.queue);
}

function hasProject(card) {
    return card.project != undefined;
}

function attachCard(col, card) {
    if (col.adjacentStatus && col.adjacentStatus == card.status) {
        col.adjacentCards.push(card);
    } else {
        col.cards.push(card);
    }
}

function evalID() {
    var pathArray = window.location.pathname.split('/');
    let len = pathArray.length;
    if (len < 3) return "";
    if (pathArray[len-2] != "board") return "";
    return pathArray[len-1];
}

function evalMaskData() {
    var url = new URL(window.location.href);
    return url.searchParams.get("mask") == "1";
}
