var globalTrackerUrl = "https://st.yandex-team.ru/";
var globalPullRequestUrl = "https://a.yandex-team.ru/review/";

var maxDaysTicketInState = 28;
var noTimedAlertStatuses = ["open", "backlog", "closed"];
var noTimedAlertTypes = ["project"];

function labelForID(id) {
    var labels = {
        "rtec": "RTec board",
        "sre": "Mail SRE board",
    };
    return labels[id] || "";
}

function queryForID(id) {
    var queries = {
        "rtec": [
            "queue: RTEC type:!project resolution:empty() ("
            + "status:!open or (status:open and type:complaint)"
            + ") tags:!\"blocked:need_info\" \"Sort%20By\": statusStartTime",
            "queue: RTEC type: complaint resolution:empty() tags:\"blocked:need_info\" \"Sort%20By\": statusStartTime",
            "queue: RTEC resolved: > today() - \"1W\" \"Sort%20By\": statusStartTime DESC",
            "queue: MAILSRE tags: rtec status: !open resolved: > today() - \"1W\" \"Sort%20By\": statusStartTime DESC"
        ],
        "arch360": [
            "queue: ARCHPCHT \"Sort%20By\": statusStartTime",
        ],
        "bbps": [
            "queue: BBPS \"Sort%20By\": statusStartTime",
        ],
        "rtec-upstream": [
            "queue: RTEC (type:project or \"Parent Issue\": empty()) status:open,evaluation,developmentQueue resolution:empty() updated: >= \"01.04.2021\" \"Sort%20By\": deadline DESC, statusStartTime DESC",
        ],
        "sre": ["queue:MAILSRE and (resolution:empty()  or resolved: > today() - \"1W\")"
            + " \"Sort%20By\":statusStartTime",
            "Queue: SPI AND \"Компоненты\": mail AND Status: !Закрыт AND Created: >= today() - \"3W\""
        ],
        "nordsturm": [
            "queue: NORDSTURM"
        ],
        "kharybin": [
            "queue: KHARYBIN"
        ],
        "mc": [
            "queue: MAILDLV, MAILDEV and status:!closed and type: development, research, service \"Sort%20By\":statusStartTime",
            "queue: MAILDLV, MAILDEV and resolved: > today() - \"1W\" and type: development, research, service \"Sort%20By\": statusStartTime DESC"
        ],
        "fan": [
            "queue: RTEC and resolution:empty() and components:Fan \"Sort%20By\": statusStartTime",
            "queue: FANFRONT and resolution:empty() \"Sort%20By\": statusStartTime",
            "queue: RTEC resolved: > today() - \"1W\" and components:Fan \"Sort%20By\": statusStartTime DESC",
            "queue: FANFRONT resolved: > today() - \"1W\" \"Sort%20By\": statusStartTime DESC",
        ],
        "b2b-crm": [
            "queue: CRMPCHT resolution: empty() \"Sort%20By\": statusStartTime",
        ],
        "tractor": [
            "queue: RTEC and resolution:empty() and components:Migrations \"Sort%20By\": statusStartTime",
            "queue: RTEC resolved: > today() - \"1W\" and components:Migrations \"Sort%20By\": statusStartTime DESC",
        ]
    };
    return queries[id] || [];
}

function schemaForID(id) {
    var schemas = {
        "rtec":[
            {
                "displayName":"",
                "types":["bug","service","incident","infrastructureTask","development","research"],
                "cols":[
                    {
                        "status":"backlog",
                        "title":"Бэклог",
                        "limit": 8
                    },
                    {
                        "status": "designed",
                        "title": "Дизайн",
                        "limit": 6,
                        "adjacentStatus": "designReview",
                        "adjacentTitle": "Дизайн ревью",
                    },
                    {"status":"inProgress","title":"В работе","limit":9,
                        "adjacentStatus":"inReview","adjacentTitle":"Ревью",
                    },
                    {"status":"awaitingRelease","title":"Ждет релиза","limit":6},
                    {"status":"closed","title":"Готово","limit":0,"scrollable": 1},
                ],
            },
            {
                "types":["complaint"],
                "displayName":"Жалобы",
                "cols":[
                    {"status":"new","title":"Новые жалобы","limit":0},
                    {"status":"backlog","title":"Бэклог","limit":15},
                    {"status":"inProgress","title":"В работе","limit":12},
                    {"status":"closed","title":"Готово","limit":0,"scrollable": 1},
                ],
            },
        ],
        "arch360": [
            {
                "displayName": "",
                "cols": [
                    { "status": "inProgress", "title": "ip", "limit": 0 },
                    { "status": "waitingForApproval", "title": "waitingForApproval", "limit": 0 },
                    { "status": "resolved", "title": "resolved", "limit": 0 },
                    { "status": "closed", "title": "closed", "limit": 0 },
                ],
            },
        ],
        "bbps": [
            {
                "displayName": "",
                "components": ["Админка"],
                "cols": [
                    { "status": "product", "title": "product", "limit": 0 },
                    { "status": "developmentQueue", "title": "developmentQueue", "limit": 0 },
                    { "status": "inDevelopment", "title": "inDevelopment", "limit": 0 },
                    { "status": "experiment", "title": "experiment", "limit": 0 },
                    { "status": "resultsReview", "title": "resultsReview", "limit": 0 },
                ],
            },
            {
                "displayName": "",
                "components": ["Диск"],
                "cols": [
                    { "status": "product", "title": "product", "limit": 0 },
                    { "status": "developmentQueue", "title": "developmentQueue", "limit": 0 },
                    { "status": "inDevelopment", "title": "inDevelopment", "limit": 0 },
                    { "status": "experiment", "title": "experiment", "limit": 0 },
                    { "status": "resultsReview", "title": "resultsReview", "limit": 0 },
                ],
            },
            {
                "displayName": "",
                "components": ["Телемост"],
                "cols": [
                    { "status": "product", "title": "product", "limit": 0 },
                    { "status": "developmentQueue", "title": "developmentQueue", "limit": 0 },
                    { "status": "inDevelopment", "title": "inDevelopment", "limit": 0 },
                    { "status": "experiment", "title": "experiment", "limit": 0 },
                    { "status": "resultsReview", "title": "resultsReview", "limit": 0 },
                ],
            },
            {
                "displayName": "",
                "cols": [
                    { "status": "product", "title": "product", "limit": 0 },
                    { "status": "developmentQueue", "title": "developmentQueue", "limit": 0 },
                    { "status": "inDevelopment", "title": "inDevelopment", "limit": 0 },
                    { "status": "experiment", "title": "experiment", "limit": 0 },
                    { "status": "resultsReview", "title": "resultsReview", "limit": 0 },
                ],
            },
        ],
        "rtec-upstream":[
            {
                "types":["task"],
                "displayName":"Триаж",
                "cols":[
                    {"status":"open","title":"Триаж","limit":0},
                ],
            },
            {
                "queues":["RTEC"],
                "types": ["bug"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Дефекты","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "types": ["service"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Обслуживание","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "components":["Xiva"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Xiva","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "components":["Imap", "Pop3", "Collectors", "Bot", "Xeno"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Mail","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "components":["Fan"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Fan","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "components":["Yplatform"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Yplatform","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Остальное","limit":0},
                    {"status":"evaluation","title":"Оценка","limit":0,"adjacentStatus":"developmentQueue","adjacentTitle":"Оценено"},
                ],
            },
            {
                "queues":["RTEC"],
                "displayName":"",
                "cols":[
                    {
                        "title": "...",
                        "matchAll": true,
                    },
                ],
            },
        ],
        "sre":[
            {
                "types":["project"],
                "displayName":"Проекты",
                "cols":[
                    {"status":"inProgress","title":"Проекты в работе","limit":7},
                ],
            },
            {
                "types":["incident"],
                "displayName":"incidents",
                "cols":[
                    {"status":"neo","title":"Инциденты","limit":0},
                    {"status":"diagnostics","title":"Разбираем","limit":0},
                    {"status":"closed","title":"Разобрали","limit":0},
                ],
            },
            {
                "types":["task","bug"],
                "displayName":"tasks",
                "cols":[
                    {"status":"backlog","title":"Бэклог","limit":10},
                    {"status":"inProgress","title":"В работе","limit":8},
                    {"status":"inReview","title":"В ревью","limit":6},
                    {"status":"awaitingRelease","title":"Ждёт релиза","limit":5},
                    {"status":"closed","title":"Сделали (за неделю)","limit":0},
                ],
            },
            {
                "types":["task","bug"],
                "displayName":"tasks",
                "cols":[
                    {"status":"blocked","title":"Заблокирован","limit":0},
                ],
            },
        ],
        "nordsturm":[
            {
                "types":["task","bug","development","service"],
                "displayName":"tasks",
                "cols":[
                    {"status":"open","title":"Идеи","limit":0},
                    {"status":"inProgress","title":"В работе","limit":3},
                    {"status":"resolved","title":"Решен","limit":3},
                    {"status":"closed","title":"Сделано","limit":0},
                ],
            },
        ],
        "kharybin": [
            {
                "types":["task"],
                "displayName": "Задачи",
                "cols":[
                    {"status": "open", "title": "Открытые", "limit": 0},
                    {"status": "backlog", "title": "Бэклог", "limit": 5},
                    {"status": "inProgress", "title": "В работе", "limit": 5},
                    {"status": "closed", "title": "Готово", "limit": 0},
                ]
            }
        ],
        "mc":[
            {
                "types":["development","research"],
                "displayName":"Разработка/Исследование",
                "cols":[
                    {"status":"backlog","title":"Бэклог","limit":10},
                    {"status":"designed","title":"Проектирование","limit":7},
                    {"status":"designReview","title":"Дизайн ревью","limit":7},
                    {"status":"inProgress","title":"Разработка","limit":7},
                    {"status":"inReview","title":"Код ревью","limit":7},
                    {"status":"testing","title":"Тестируется","limit":7},
                    {"status":"awaitingRelease","title":"Ждет релиза","limit":8},
                    {"status":"closed","title":"Готово","limit":0},
                ],
            },
            {
                "types":["service"],
                "displayName":"Обслуживание",
                "cols":[
                    {"status":"backlog","title":"Бэклог","limit":10},
                    {"status":"inProgress","title":"В работе","limit":3},
                    {"status":"inReview","title":"Код ревью","limit":3},
                    {"status":"awaitingRelease","title":"Ждет релиза","limit":3},
                    {"status":"closed","title":"Готово","limit":0},
                ],
            },
        ],
        "fan":[
            {
                "displayName":"Фронт",
                "queues": ["FANFRONT"],
                "cols":[
                    {"status":"open","title":"Идеи","limit":0},
                    {"status":"inProgress","title":"В работе","limit":2,"adjacentStatus":"developmentDone","adjacentTitle":"Готово"},
                    {"status":"inReview","title":"Код ревью","limit":2},
                    {"status":"awaitingRelease","title":"Ждет релиза","limit":2},
                    {"status":"closed","title":"Готово","limit":0},
                ],
            },
            {
                "types":["bug","service","development","research","incident","infrastructureTask"],
                "queues": ["RTEC"],
                "displayName":"Бэкенд",
                "cols":[
                    {"status":"backlog","title":"TODO","limit":5},
                    {"status":"designed","title":"Дизайн","limit":3},
                    {"status":"designReview","title":"Дизайн ревью","limit":2},
                    {"status":"inProgress","title":"В работе","limit":4,"adjacentStatus":"developmentDone","adjacentTitle":"Готово"},
                    {"status":"inReview","title":"Код ревью","limit":4},
                    {"status":"awaitingRelease","title":"Ждет релиза","limit":5},
                    {"status":"closed","title":"Готово","limit":0},
                ],
            },
            {
                "types":["task","development","service","research","project"],
                "displayName":"upstream",
                "components": ["Fan"],
                "cols":[
                    {"status":"open","title":"FAN: Новые","limit":0},
                    {"status":"evaluation","title":"2й приоритет","limit":10},
                    {"status":"developmentQueue","title":"1й приоритет","limit":6},
                ]
            },
        ],
        "b2b-crm":[
            {
                "displayName":"",
                "cols":[
                    {"status":"open","title":"Новые","limit":0},
                    {"status":"contact","title":"Контакт","limit":0},
                    {"status":"presentation","title":"Презентация","limit":0},
                    {"status":"feasibilityStudy","title":"Техпроработка","limit":0},
                    {"status":"approval","title":"Согласование","limit":0},
                    {"status":"agreement","title":"Договор","limit":0},
                    {"status":"payment","title":"Оплата","limit":0},
                ],
            },
            {
                "displayName":"",
                "cols":[
                    {
                        "title":"Прочее",
                        "matchAll": true,
                        limit: 0
                    },
                ],
            },
        ],
        "tractor": [
            {
                "types":["bug","service","development","research","incident","infrastructureTask"],
                "queues": ["RTEC"],
                "displayName":"Бэкенд",
                "cols":[
                    {
                        "status":"backlog",
                        "title":"Бэклог",
                        "limit":8
                    },
                    {
                        "status": "designed",
                        "title": "Дизайн",
                        "limit": 8,
                        "adjacentStatus": "designReview",
                        "adjacentTitle": "Дизайн ревью",
                    },
                    {"status":"inProgress","title":"В работе","limit":8,
                        "adjacentStatus":"inReview","adjacentTitle":"Ревью",
                    },
                    {"status":"awaitingRelease","title":"Ждет релиза","limit":6},
                    {"status":"closed","title":"Готово","limit":0},
                ],
            }
        ]
    };
    return schemas[id] || [];
}


function statsURLForID(id) {
    var urls = {
        "rtec": "https://charts.yandex-team.ru/g/CCUNY0CzpD",
    }
    return urls[id] || "";
}
