#! /bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

source /usr/lib/qloud-functions.sh

# TODO: replace with same from qloud-functions.sh
function ephemeral_log {
    rm -rf "/app/log"
    mkdir -p "/ephemeral/app/log"
    ln -s "/ephemeral/app/log" /app/
}

function ephemeral_var {
    rm -rf "/var/$1"
    mkdir -p "/ephemeral/var/$1"
    ln -s "/ephemeral/var/$1" /var/
}

user=app
environment=$QLOUD_ENVIRONMENT

[[ $environment ]] \
    || { echo "check env variables" > /errlog ; exit 1; }

# /home
mkdir -p /home/$user
chown -R -H $user:$user /home/$user

# Prepare secrets
mkdir -p /app/secrets
declare -a qloud_secrets=(
    "/etc/$QLOUD_APPLICATION"
    "/etc/yamail"
    "/home/$QLOUD_APPLICATION"
    "/home/xiva"
    "/var/$QLOUD_APPLICATION"
    "/root/.postgresql"
    "/home/xiva/.yt"
)
secret_pattern="(.*\.(pem|crt))|(.*(tvm|dhparam|vapid|pgpass|passwd|token|encryption|versioned_keys|secret|oauth).*)"
for path in "${qloud_secrets[@]}" ; do
    [[ ! -d $path ]] && continue
    chmod 755 $path
    find $path -type f -regextype egrep -regex $secret_pattern | xargs -I {} ln -svf {} /app/secrets/
done

chown -RL $user:$user /app/secrets

# Prepare postgres secrets
[[ -f /home/$user/.pgpass ]] && chmod 600 /home/$user/.pgpass
[[ -f /home/$user/.postgresql/root.crt ]] && chmod 644 /home/$user/.postgresql/root.crt

# Make sure /ephemeral has correct permissions first.
chmod 775 /ephemeral

ephemeral_log
mkdir -p /tmp/app/ || true
ls /var/app/* &>/dev/null && rm -rf /tmp/app/* && mv /var/app/* /tmp/app/
ephemeral_var app
ls /tmp/app/* &>/dev/null && mv /tmp/app/* /var/app/

env | grep QLOUD >> /etc/environment
echo $environment > /etc/environment.name

push_client_config="/app/push-client/$environment.yml"
if [[ -f $push_client_config ]]; then
    mkdir -p /var/lib/push-client
    chown -R -H statbox:statbox /var/lib/push-client
    chmod 775 /var/lib/push-client
    chmod 644 /app/secrets/tvm_secret
fi

/app/init/fix_crontab

# for config file
if [[ ! -f /app/config/config.yml || -L /app/config/config.yml ]]; then
    ln -sf /app/config/$environment.yml /app/config/config.yml
fi

# TODO: setup welcome and about scripts
fgrep -q '/usr/bin/welcome' /root/.bashrc || echo '/usr/bin/welcome' >> /root/.bashrc
fgrep -q 'alias gdb' /root/.bashrc || echo 'alias gdb="ya tool gdb -q"' >> /root/.bashrc # TODO: add in deploy

# /usr
chmod 744 /usr/bin/restart

# TODO: check for xivahub
# for f in $(find /usr/share/$app/entrypoint.d/prerun*.sh 2>/dev/null); do
#   [[ -f "$f" ]] && { bash "$f" || { echo "prerun script \"$f\" failed"; exit 1; }; }
# done

# logrotate
# Replace workload_signal from mail-base image
if [[ -f /app/tools/workload_signal ]]; then
    chmod 744 /app/qloud/workload_signal_patch
    cp /app/qloud/workload_signal_patch /app/tools/workload_signal
fi

### START
monrun_prepare

manage-balancer restore

uidstatbox=$(id -u statbox)
uidmonitor=$(id -u monitor)

function cpu_limit_fraction {
    if [[ -z "$DISABLE_CPU_LIMITS_FOR_SUBCONTAINERS" ]]; then
        fraction=$1
        awk \
            -v cores="$QLOUD_CPU_GUARANTEE" \
            -v fraction="$fraction" \
            'BEGIN {
                ret = cores * fraction;
                printf("%.1fc", ret > 0.1 ? ret : 0.1)
            }'
    else
        echo "$QLOUD_CPU_GUARANTEE"
    fi
}

# TODO: fix juggler setup
portoctl run self/sub_juggler \
    respawn=true \
    isolate=false \
    user=$uidmonitor \
    cpu_limit=$(cpu_limit_fraction 0.05) \
    command='/usr/bin/juggler-client --config-dir /home/monitor/juggler/etc'

portoctl run self/sub_unistat_daemon \
    respawn=true \
    isolate=false \
    user=$uidmonitor \
    cpu_limit=$(cpu_limit_fraction 0.1) \
    command="python3 /usr/share/yandex-mail-common/unistat_daemon.py"

portoctl run self/sub_cron \
    respawn=true \
    isolate=false \
    cpu_limit=$(cpu_limit_fraction 0.2) \
    command='/usr/sbin/cron -f'

if [[ -f $push_client_config ]]; then
    portoctl run self/sub_pushclient \
        respawn=true \
        isolate=false \
        cpu_limit=$(cpu_limit_fraction 0.1) \
        user=$uidstatbox \
        memory_limit=512000000000 \
        command="/usr/bin/push-client -f -c $push_client_config"
fi

cd /

portoctl run self/sub_main \
    respawn=true \
    isolate=false \
    command="/app/app /app/config/config.yml" \
    cwd='/' \
    ulimit='core: unlimited;' \
    stdout_path="/tmp/app-stdout" \
    stderr_path="/tmp/app-stderr" \
    core_command="cp --sparse=always /dev/stdin /var/cores/crash-app.core" \
    env='PGPASSFILE=/app/secrets/.pgpass;PGSSLROOTCERT=/app/secrets/root.crt'

# TODO: check usage
# for f in `find /usr/share/$app/entrypoint.d/postrun*.sh 2>/dev/null`; do
#   [[ -f "$f" ]] && { bash "$f" || { echo "postrun script \"$f\" failed"; exit 1; }; }
# done

exec /bin/sleep infinity
