function collect_codes(status, prefix, out) {
    out[prefix"."status]++
}

function collect_values(value, signal, out) {
    if (value != "") {
        out[signal] = out[signal] == "" ? value : out[signal]","value
    }
}

function values_to_hg(pattern, out) {
    for (i in out) {
        if (i ~ pattern) out[i] = "["out[i]"]"
    }
}

function collect_timings(value, prefix, out) {
    if (value != "") {
        out[prefix] = out[prefix] == "" ? out[prefix]""value : out[prefix]","value
    }
}

function finalize_timings(out) {
    for (i in out) {
        if (i ~ /timings/) out[i] = "["out[i]"]"
    }
}

function get_tskv_value(full_str, tskv_key) {
    tskv_regex = "\t" tolower(tskv_key) "=([^\t]+)"
    match(tolower(full_str), tskv_regex, tskv_val_arr)
    return tskv_val_arr[1]
}

function parse(result) {
    delete result
    for (i=1; i <= NF; i++) {
        gsub(" +", "_", $i)
        gsub("/+", "_", $i)
        gsub("=_+", "=", $i)
        sub(/?.*/, "", $i)
        $i = tolower($i)
        split($i, _a, "=")
        if (_a[1] ~ /^[a-zA-Z0-9_.-]+$/ && _a[2] ~ /^[a-zA-Z0-9_.,-]+$/) {
            result[_a[1]] = _a[2]
        }
    }
}

function parse_host(host) {
    sub(/host=/, "", host)
    sub(/\.mail\.yandex\.net/, "", host)
    sub(/\.yandex\.net/, "", host)
    sub(/\.yandex-team\.ru/, "", host)
    if (match(host, /hub-shard[0-9]+-[0-9]+/)) {
        host=substr(host, RSTART, RLENGTH)
    }
    gsub(/\./, "_", host)
    return host
}

function format(base, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9) {
    if (length(arg1)) sub("{}", arg1, base)
    if (length(arg2)) sub("{}", arg2, base)
    if (length(arg3)) sub("{}", arg3, base)
    if (length(arg4)) sub("{}", arg4, base)
    if (length(arg5)) sub("{}", arg5, base)
    if (length(arg6)) sub("{}", arg6, base)
    if (length(arg7)) sub("{}", arg7, base)
    if (length(arg8)) sub("{}", arg8, base)
    if (length(arg9)) sub("{}", arg9, base)
    return base
}