#!/bin/bash

# Rotate happens at 00:00. Timeout 118800 in order to know that rotate not completed by 9:00.
PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logdir="/app/log"
logfiles=$(ls "$logdir"/*.log "$logdir"/*.typed "$logdir"/*.tskv 2>/dev/null)
ts=$(date +"%s")

if [[ -z $logfiles ]]; then
  echo "PASSIVE-CHECK:mail-logrotate;2;No logfiles in $logdir"
  exit
else
  for file in $logfiles; do
    log_time=$(stat -c%Y "$file")
    if (( $ts - $log_time > 118800 )); then
      echo "PASSIVE-CHECK:mail_logrotate;2;$file updated too long ago"
      exit
    fi
    if [[ -f "$file".0 && ! -f "$file".0.gz ]]; then
      echo "PASSIVE-CHECK:mail-logrotate;2;$file.0 not compressed"
      exit
    fi
    if [[ -f "$file".0.gz ]]; then
      rotate_time=$(stat -c%Y "$file".0.gz)
      if (( $log_time - $rotate_time > 118800 )); then
        echo "PASSIVE-CHECK:mail-logrotate;2;$file.0.gz was rotated too long ago"
        exit
      fi
    fi
  done
fi

echo "PASSIVE-CHECK:mail_logrotate;0;OK"