#!/bin/bash

[[ "$TRACE" ]] && set -x

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

if [[ ! -d "/var/log/metrics/" ]]; then
    mkdir "/var/log/metrics/"
fi

scripts=$@

for script_file in ${scripts[@]}; do
    script_name="$(basename $script_file)"
    lockfile="/tmp/$script_name.lck"
    (
        flock -xn 200 || exit 1
        trap "rm -f $lockfile" EXIT

        metrics_file="/var/log/metrics/$script_name.metrics"
        tmp_metrics_file="$metrics_file.tmp"
        > "$tmp_metrics_file"
        $script_file >> $tmp_metrics_file
        mv "$tmp_metrics_file" "$metrics_file"

    ) 200> "$lockfile"
done
