#!/bin/bash

[[ "$TRACE" ]] && set -x

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

lockfile="/tmp/$(basename $0).lck"
(
    flock -xn 200 || exit 1
    trap "rm -f $lockfile" EXIT

    # hack: exclude most of statport metrics to reduce total push metrics count
    # metrics are still being sent by unistat daemon
    cat /var/log/metrics/metrics | grep -v PASSIVE-CHECK | grep -v httpout | grep -v hubrpc | grep -v statport | python3 /usr/share/yandex-mail-common/yasm-formatter.py > /tmp/app.yasm-metrics

    curl -s -d @/tmp/app.yasm-metrics localhost:11005

) 200> "$lockfile"
