from collections import defaultdict
import json
import sys
import os

if 'QLOUD_ENVIRONMENT' in os.environ:
    ctype = os.environ.get('QLOUD_ENVIRONMENT')
else:
    stage = os.environ.get('DEPLOY_STAGE_ID')
    ctype = stage[stage.rfind('_') + 1:]

if 'QLOUD_APPLICATION' in os.environ:
    prj = os.environ.get('QLOUD_APPLICATION')
else:
    prj = os.environ.get('DEPLOY_STAGE_ID')

if 'QLOUD_DATACENTER' in os.environ:
    geo = os.environ.get('QLOUD_DATACENTER')
else:
    geo = os.environ.get('DEPLOY_NODE_DC')

ttl = 30

tag_metrics = defaultdict(list)

def make_metric(name, value):
    return {'name': name, 'val': json.loads(value)}

def add_tags_and_ttl_to_metrics(tag, metrics):
    return {
        'tags': {
            'ctype': ctype,
            'prj': prj,
            'geo': geo,
            'tier': tag
        },
        'values': metrics,
        'ttl': ttl
    }

metrics = sys.stdin.readlines()
for metric in metrics:
    metric_parts = metric.strip().split(' ')
    if len(metric_parts) == 3:
        name, value, _ = metric_parts
        tag = 'none'
    elif len(metric_parts) == 4:
        name, value, _, tag = metric_parts
        if not tag:
            tag = 'none'
    else:
        continue

    name = name.replace('.', '_')
    if name.endswith('_hgram'):
        name = name[:-len('_hgram')]
        tag_metrics[tag].append(make_metric(name + '_hhhh', value))
    elif name.endswith('_max'):
        name = name[:-len('_max')]
        tag_metrics[tag].append(make_metric(name + '_axxx', value))
    elif 'timings' in name or 'histogram' in name:
        tag_metrics[tag].append(make_metric(name + '_hhhh', value))
    else:
        tag_metrics[tag].append(make_metric(name + '_hhhh', value))
        tag_metrics[tag].append(make_metric(name + '_teee', value))

result = []
for tag, metrics in tag_metrics.items():
    result.append(add_tags_and_ttl_to_metrics(tag, metrics))

print(json.dumps(result))
