#! /bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

# TODO merge functions
function ephemeral_log {
    rm -rf "/var/log/$1"
    mkdir -p "/ephemeral/logs/$1"
    ln -s "/ephemeral/logs/$1" /var/log/
}
function ephemeral_var {
    rm -rf "/var/$1"
    mkdir -p "/ephemeral/$1"
    ln -s "/ephemeral/$1" /var/
}

if [[ -z "$APPLICATION" ]]; then
    export APPLICATION=$QLOUD_APPLICATION
fi

app=$APPLICATION
environment=$QLOUD_ENVIRONMENT
user=$QLOUD_EXEC_USER

[[ $app && $environment && $user ]] \
    || { echo "check env variables" > /errlog ; exit 1; }

if [[ -z "$HARDWARE_HACK" ]]; then
    # Make sure /ephemeral hase correct permissions first.
    chmod 775 /ephemeral

    ephemeral_log $app
    mkdir -p /tmp/$app/ || true
    ls /var/$app/* &>/dev/null && rm -rf /tmp/$app/* && mv /var/$app/* /tmp/$app/
    ephemeral_var $app
    ls /tmp/$app/* &>/dev/null && mv /tmp/$app/* /var/$app/
fi

if ! id -u $user &>/dev/null; then
    adduser --system --disabled-password --group $user
    service procps restart
fi

env | grep QLOUD >> /etc/environment
echo "MAIL_LOGBACKUP_HOST_TYPE=${MAIL_LOGBACKUP_HOST_TYPE}" >> /etc/environment
echo "APPLICATION=${APPLICATION}" >> /etc/environment
echo $environment > /etc/environment.name

for file in $(find /etc/statbox-push-client/*.yaml-${environment} 2>/dev/null); do
    ln -sf ${file} $(echo ${file} | sed "s/-${environment}$//")
done

[[ $PUSH_CLIENT_IDENT ]] \
    && sed -i "s/PUSH_CLIENT_IDENT/$PUSH_CLIENT_IDENT/" /etc/statbox-push-client/*.yaml

[[ $(find /etc/statbox-push-client/ -name '*.yaml') && -f /etc/$app/tvm_secret ]] \
    && sed -i "s/PUSH_CLIENT_TVM_SECRET/$(cat /etc/$app/tvm_secret)/" /etc/statbox-push-client/*.yaml

mapfile -t push_clients < <(find /etc/statbox-push-client/*.yaml 2>/dev/null | xargs -n1 basename | cut -d'.' -f1)
for name in ${push_clients[*]}; do
    mkdir -p /var/lib/push-client-$name
    chown -R -H statbox:statbox /var/lib/push-client-$name
    chmod 775 /var/lib/push-client-$name
done

for key in APPLICATION QLOUD_APPLICATION QLOUD_ENVIRONMENT QLOUD_COMPONENT QLOUD_DATACENTER QLOUD_EXEC_USER; do
    value="${!key}"
    for file in $(fgrep -r -l "%$key%" /etc); do
        sed -i 's/#*%'"$key"'%/'"$value"'/g' "$file"
    done
done

# add \n to crontabs
for file in $(find /etc/cron.d -type f); do
    [[ $(tail -c 1 $file | wc -l) -eq 0 ]] && echo >> $file
done

# for config file
if [[ ! -f /etc/$app/config.yml || -L /etc/$app/config.yml ]]; then
    ln -sf /etc/$app/$environment.yml /etc/$app/config.yml
fi

# for included files
for f in $(find /etc/$app/*-$environment 2>/dev/null); do
    target_name=$(echo "$f" | sed 's/-'"$environment"'$//')
    ln -sf "$f" "$target_name"
done

# /etc
chown -R -H $user:$user /etc/$app
chown -R -H monitor:monitor /etc/monrun
[[ -d /etc/statbox-push-client ]] \
    && chown -R -H statbox:statbox /etc/statbox-push-client \
    && chmod 600 /etc/statbox-push-client/*
chmod 644 /etc/cron.d/*
chmod 644 /etc/logrotate.d/*
chmod 440 /etc/sudoers.d/*
find /etc/cron.yandex/ -type f -exec chmod 744 {} \;
[[ -f /etc/$app/about ]] \
    && mv /etc/$app/about /usr/share/$app/about \
    && echo "cat /usr/share/$app/about" > /usr/bin/about \
    && chmod 755 /usr/bin/about

# /home
chown -R -H $user:$user /home/$user
[[ -f /home/$user/.pgpass ]] && chmod 600 /home/$user/.pgpass
[[ -f /home/$user/.postgresql/root.crt ]] && chmod 644 /home/$user/.postgresql/root.crt

# /root
chmod 755 /usr/bin/welcome
fgrep -q '/usr/bin/welcome' /root/.bashrc || echo '/usr/bin/welcome' >> /root/.bashrc
fgrep -q 'alias gdb' /root/.bashrc || echo 'alias gdb="ya tool gdb -q"' >> /root/.bashrc

# /usr
[[ -d /usr/share/$app/monitoring.d/ ]] || mkdir -p /usr/share/$app/monitoring.d
[[ -d /usr/share/$app/monrun/ ]] || mkdir -p /usr/share/$app/monrun
chmod 755 /usr/share/$app/
chmod -R 755 /usr/share/$app/monitoring.d/
chmod -R 755 /usr/share/$app/monrun/
chmod -R 755 /usr/share/graphite-client/
chmod 755 /usr/share/yandex-mail-common/*.sh
chmod -R 755 /usr/share/yandex-mail-common/monitorings/
chmod 744 /usr/bin/restart

# /var
chown -R -H $user:$user /var/$app
chown -R -H $user:$user /var/log/$app
chmod 755 /var/$app/
chmod 777 /var/log/
chmod 755 /var/log/$app/
ln -sf "/var/log/$app" /log

chmod 777 /coredumps

for f in $(find /usr/share/$app/entrypoint.d/prerun*.sh 2>/dev/null); do
  [[ -f "$f" ]] && { bash "$f" || { echo "prerun script \"$f\" failed"; exit 1; }; }
done

### START
sudo -u monitor /usr/bin/monrun --gen-jobs

manage-balancer restore

uidmonitor=$(id -u monitor)
uidstatbox=$(id -u statbox)

yasmagent_cmd='/usr/local/yasmagent/python/bin/python -B /usr/local/yasmagent/run.py'
yasmagent_cmd+=' --fg --config=/usr/local/yasmagent/agent.conf --log-dir=/var/log/yasmagent'
yasmagent_cmd+=' --pid-file=/usr/local/yasmagent/run/agent.pid'
yasmagent_cmd+=' --yasmutil-dir=/usr/local/yasmagent/lib --http-port=11003'
yasmagent_cmd+=' --push-enabled --push-http-port 11005'

function cpu_limit_fraction {
    if [[ -z "$DISABLE_CPU_LIMITS_FOR_SUBCONTAINERS" ]]; then
        fraction=$1
        awk \
            -v cores="$QLOUD_CPU_GUARANTEE" \
            -v fraction="$fraction" \
            'BEGIN {
                ret = cores * fraction;
                printf("%.1fc", ret > 0.1 ? ret : 0.1)
            }'
    else
        echo "$QLOUD_CPU_GUARANTEE"
    fi
}

if [[ -z "$HARDWARE_HACK" ]]; then
    portoctl run self/sub_juggler \
        respawn=true \
        isolate=false \
        user=$uidmonitor \
        cpu_limit=$(cpu_limit_fraction 0.05) \
        command='/usr/bin/juggler-client --config-dir /home/monitor/juggler/etc'

    portoctl run self/sub_yasmagent \
        respawn=true \
        isolate=false \
        user=$uidmonitor \
        cpu_limit=$(cpu_limit_fraction 0.1) \
        command="$yasmagent_cmd"

    portoctl run self/sub_unistat_daemon \
        respawn=true \
        isolate=false \
        user=$uidmonitor \
        cpu_limit=$(cpu_limit_fraction 0.1) \
        command="python3 /usr/share/yandex-mail-common/unistat_daemon.py"

    portoctl run self/sub_cron \
        respawn=true \
        isolate=false \
        cpu_limit=$(cpu_limit_fraction 0.2) \
        command='/usr/sbin/cron -f'

    for name in ${push_clients[*]}; do
        portoctl run self/sub_pushclient_$name \
            respawn=true \
            isolate=false \
            cpu_limit=$(cpu_limit_fraction 0.1) \
            user=$uidstatbox \
            memory_limit=512000000000 \
            command="/usr/bin/push-client -f -c /etc/statbox-push-client/$name.yaml"
    done

    cd /

    portoctl run self/sub_main \
        respawn=true \
        isolate=false \
        command="/usr/sbin/$app /etc/$app/config.yml" \
        cwd='/' \
        ulimit='core: unlimited;' \
        stdout_path="/tmp/$app-stdout" \
        stderr_path="/tmp/$app-stderr" \
        core_command="cp --sparse=always /dev/stdin /var/cores/crash-${app}.core"
fi

for f in `find /usr/share/$app/entrypoint.d/postrun*.sh 2>/dev/null`; do
  [[ -f "$f" ]] && { bash "$f" || { echo "postrun script \"$f\" failed"; exit 1; }; }
done

if [[ -z "$HARDWARE_HACK" ]]; then
    exec /bin/sleep infinity
fi
