#!/bin/bash

[[ "$TRACE" ]] && set -x

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

lockfile="/tmp/$(basename $0).lck"
(
    flock -xn 200 || exit 1
    trap "rm -f $lockfile" EXIT

    common_monitorings="/usr/share/yandex-mail-common/monitorings/*"
    if [[ -z "$APPLICATION" ]]; then
        service_monitorings="/app/monitoring/*"
    else
        service_monitorings="/usr/share/$APPLICATION/monitoring.d/*"
    fi
    fast_metrics_tag="#[ ]*fast-launch"
    scripts="$(egrep -l "$fast_metrics_tag" $service_monitorings $common_monitorings)"

    /usr/share/yandex-mail-common/run-collect-metrics-scripts.sh $scripts
    /usr/share/yandex-mail-common/merge-metrics.sh
    /usr/share/yandex-mail-common/send-metrics.sh

) 200> "$lockfile"
