#!/bin/bash

[[ "$TRACE" ]] && set -x

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

metrics_file="/var/log/metrics/metrics"

lockfile="/tmp/$(basename $0).lck"
(
    flock -xn 200 || exit 1
    trap "rm -f $lockfile" EXIT

    tmp_metrics_file="$metrics_file.new"
    > "$tmp_metrics_file"
    # not older than 1 min
    actual_metrics_files="$(find /var/log/metrics/ -name '*.metrics' -type f -mmin -1.0)"
    cat $actual_metrics_files >> "$tmp_metrics_file"
    mv "$tmp_metrics_file" "$metrics_file"

) 200> "$lockfile"
