BEGIN {
    if (length(multiplier) == 0) {
        multiplier = 1
    }
}

/{}/ {
    next
}

$1 ~ /timings\.|_hgram$/ {
    if (NF < 2 || NF > 3) next
    if (length($3)) {
        metrics_by_tier[$3][$1] = metrics_by_tier[$3][$1] "," $2
    } else {
        metrics[$1] = metrics[$1] "," $2
    }
}

$1 !~ /timings\.|_hgram$/ {
    if (NF < 2 || NF > 3) next
    if (length($3)) {
        metrics_by_tier[$3][$1] += $2 * multiplier
    } else {
        metrics[$1] += $2 * multiplier
    }
}

END {
    for (i in metrics) {
        if (i ~ /timings\.|_hgram$/) {
            sub(",", "", metrics[i])
            metrics[i]= "[" metrics[i] "]"
        }
        print i, metrics[i]
    }
    for (i in metrics_by_tier) {
        for (j in metrics_by_tier[i]) {
            if (j ~ /timings\.|_hgram$/) {
                sub(",", "", metrics_by_tier[i][j])
                metrics_by_tier[i][j] = "[" metrics_by_tier[i][j] "]"
            }
            print j, metrics_by_tier[i][j], i
        }
    }
}