# Juggler алерты
Алерты [juggler](https://juggler.yandex-team.ru) используются для того, чтобы оповестить ответственных о поломке. На хостах во всех компонентах xiva monrun запускает скрипты проверок, агрегаты конфигурируются с помощью ansible_juggler. Скрипты проверок лежат в докер-образах соответствующих компонент в `/usr/local/yandex/monitoring`, конфиги monrun – в `/etc/monrun/conf.d`.

## Типы проверок
Проверки бывают двух видов: активные и пассивные.
* Пассивная проверка состоит из двух частей: скрипта для запуска monrun'ом и её описания в juggler. Склеиваются они между собой через host/service проверки: имя проверки в конфиге monrun должно совпадать с ключом service в агрегате в ansible, поле children в агрегате должно включать hostname машины, на которой крутится monrun.
* Активная проверка состоит только из её описания в juggler, данные для агрегации juggler собирает сам. Какие именно - зависит от имени проверки.

## Ansible-конфиги juggler
Здесь лежат описания алертов juggler и конфиги apnsible-playbook. Названия конфигов соответствуют приложениям в qloud и содержат соответствующие переменные. Описания проверок содержатся в файлах `templates/[компонент]_qloud_check`, файл `templates/base_qloud_check` содержит проверки, общие для всех компонент. В `templates/vars` лежат шаблоны, использующиеся в проверках.

## Проверка применение шаблонов
Для проверки и применения шаблонов используется утилита [ansible-playbook](https://wiki.yandex-team.ru/sm/juggler/ansible/). Для проверки используется с ключом `--check`:
```
ansible-playbook mail_xxx_xxx.yml --check
```

Чтобы применить конфигурацию проверок, нужен OAuth-токен. Получить его можно [тут](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=cd178dcdc31a4ed79f42467f2d89b0d0), положить нужно в переменную `JUGGLER_OAUTH_TOKEN`. Затем запустить ansible-playbook для нужного компонента:
```
ansible-playbook mail_xxx_xxx.yml
```

## Как происходит мониторинг
* На хостах monrun периодически запускает скрипты и отправляет их результаты на сервер juggler через juggler-client.
* Сервер juggler агрегирует эти результаты по правилам из ansible-juggler-configs и отправляет уведомления, если что-то сломалось.
* Для активных проверок сервер juggler периодически выполняет действие проверки, агрегирует результаты, отправляет уведомления.

Чтобы поправить скрипт проверки, выполняющийся на хосте, достаточно доставить на хост новую версию этого скрипта (собрать новый докер-образ и раскатить, разложить executer'ом и т.п.).

## Добавление новой проверки
Чтобы создать новую проверку, нужно:
* написать скрипт для monrun, разложить его по хостам;
* написать конфиг агрегации, отправить на сервер juggler с помощью ansible.
Если сделать наоборот, то на написание скрипта для monrun и доставку его на хосты будет 20 минут (downtime для свежей проверки по умолчанию), потом свежесозданный агрегат загорится `CRITICAL:NO DATA`.
