#! /usr/bin/env python3

import sys
import urllib3
import datetime

if len(sys.argv) != 3:
    print(
        "usage: {} <from_date> <to_date>\n\n<from_date>: DD-MM-YYYY\n<to_date>: DD-MM-YYYY".format(
            sys.argv[0]
        )
    )
    sys.exit(1)

from_ts = int(datetime.datetime.strptime(sys.argv[1], "%d-%m-%Y").timestamp())
to_ts = int(datetime.datetime.strptime(sys.argv[2], "%d-%m-%Y").timestamp())

projects = [
    ("xiva_main", "env=production"),
    ("xiva_main", "env=corp"),
    ("xiva_tech", "env=production"),
    ("xiva_tech", "env=corp"),
    ("xiva_server", "env=production"),
    ("xiva_server", "env=corp"),
    ("xiva_mail", "env=production"),
    ("xiva_mail", "env=corp"),
    ("xiva_db", "env=production;role=primary;db=xstore"),
    ("xiva_db", "env=corp;role=primary;db=xstore"),
    ("xiva_db", "env=production;role=primary;db=xtable"),
    ("xiva_db", "env=corp;role=primary;db=xtable"),
    ("xeno", "env=production"),
    ("collectors", "env=production"),
    ("imap", "env=production"),
    ("imap", "env=corp"),
    ("pop3", "env=production"),
]
snapshot_base_url = "https://s.yasm.yandex-team.ru/template/panel/{panel}_panel/{params}/?from={from_ts}000&to={to_ts}000&static=1"
panel_base_url = "https://yasm.yandex-team.ru/template/panel/{panel}_panel/{params}/?from={from_ts}000&to={to_ts}000"
http = urllib3.PoolManager()
skipped = []

for panel, params in projects:
    params_printable = params.replace("env=", "")
    try:
        url = snapshot_base_url.format(panel=panel, params=params, from_ts=from_ts, to_ts=to_ts)
        r = http.request("GET", url, redirect=False)
        if r.status == 302:
            snapshot_url = r.headers["Location"]
            panel_url = panel_base_url.format(
                panel=panel, params=params, from_ts=from_ts, to_ts=to_ts
            )
            print("<{{{} {}\n(({} {}))}}>".format(panel, params_printable, panel_url, snapshot_url))
        else:
            skipped.append((panel, params_printable, r.status))
    except Exception as e:
        skipped.append((panel, params_printable, str(e)))

if len(skipped):
    for panel, params_printable, reason in skipped:
        print("skip {} {}: {}".format(panel, params_printable, reason))
