#!/bin/bash

function update_panel() {
    panel_name=$1
    echo "update panel $1"
    curl --retry 2 --retry-delay 5 -f --data-binary @$panel_name.j2 "https://yasm.yandex-team.ru/srvambry/tmpl/panels/update/content?key=$panel_name"
}

function update_alert() {
    alert_name=$1
    echo "update alert $1"
    curl --retry 2 --retry-delay 5 -f --data-binary @$alert_name.j2 "https://yasm.yandex-team.ru/srvambry/tmpl/alerts/update/content?key=$alert_name" || exit -1
    echo "apply alert $1"
    curl --retry 2 --retry-delay 5 -X POST "https://yasm.yandex-team.ru/srvambry/tmpl/alerts/apply/$alert_name"
}

commons=(rtec_common.j2 $(ls $PRJ*common.j2))
if [[ $? == 0 ]]; then
    for file in ${commons[@]}; do
        update_panel ${file%.*} || exit -1
        update_alert ${file%.*} || exit -1
    done
fi

panels=$(ls $PRJ*_panel.j2)
if [[ $? == 0 ]]; then
    for panel in ${panels[@]}; do
        update_panel ${panel%.*} || exit -1
    done
fi

alerts=(rtec_common_alerts.j2 $(ls $PRJ*_alerts.j2))
if [[ $? == 0 ]]; then
    for alert in ${alerts[@]}; do
        update_alert ${alert%.*} || exit -1
    done
fi
