#! /bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

if uname | grep -q Darwin; then
    which greadlink &>/dev/null || { echo "Error: greadlink not found, please install coreutils" 1>&2; exit 1; }
    readlink="greadlink"
fi
[[ "$readlink" ]] || readlink="readlink"

me="$("$readlink" -f "$0")"
setup_root="$(dirname "$me")"
config_file="$setup_root/black.toml"
dirs_to_format="$setup_root/black_dirs"

function find_mail_root()
{
    my_path="$setup_root"
    while [[ "$my_path" != "." ]]; do
        my_path="$(dirname "$my_path")"
        if [[ "$my_path" == */mail ]]; then
            echo "$my_path"
            exit 0;
        fi
    done;
    exit 1;
}

mail_root="$(find_mail_root)"

function format_dir
{
    dir="$1"
    config_file="$2"

    find "$dir" -name '*.py' -execdir ya tool black_py2 --config "$config_file" --quiet {} \;
}

function format_all
{
    for dir in $(<"$dirs_to_format"); do
        dir="$mail_root/$dir"
        format_dir "$dir" "$config_file"
    done
}

function format_current
{
    format_dir "." "$config_file"
}

function extension-hook
{
    # Check whether we need to format the file.
    shopt -s nocasematch
    assume_filename_arg="$3"
    for dir in $(<"$dirs_to_format"); do
        [[ "$assume_filename_arg" =~ "$mail_root/$dir".* ]] && need_format=yes
    done
    [[ "$need_format" ]] || exit 0;

    ya tool black_py2 --config "$config_file" "$@"
}

case "$1" in
help | -help | --help | -h )
    echo 'usage: apply_black all|current|<extension-args>'
    ;;
all )
    format_all
    exit "$?"
    ;;
current )
    format_current
    exit "$?"
    ;;
--version )
    ya tool black_py2 --version
    exit "$?"
    ;;
* )
    extension-hook "$@"
    exit "$?"
    ;;
esac
