#!/bin/bash

# Initial
sudo apt update

## Optional
### rm /etc/apt/sources.list.d/mirror.list

# PG certificate
mkdir ~/.postgresql
wget "https://crls.yandex.net/allCAs.pem" -O ~/.postgresql/root.crt
chmod 0600 ~/.postgresql/root.crt

## [TODO deprecate] PG development pgpass
### touch ~/.pgpass
### sudo chmod 0600 ~/.pgpass
### nano ~/.pgpass

# PG client
sudo apt -y install postgresql-client

# Python
pip install \
    mypy \
    websockets \
    pytest

# VCS
sudo apt -y install git git-svn subversion
### sudo apt -y install yandex-arc-launcher
### systemctl --user enable --now arc-update.timer
ssh-keyscan -H bb.yandex-team.ru 2>/dev/null 1>> ~/.ssh/known_hosts

(cd ~ && git clone --depth 1 ssh://git@bb.yandex-team.ru/mail/asg.git &&  asg/asg-integrate-bash)
# if asg config written to .bashrc
if [[ -f $HOME/.bashrc ]] && ([[ ! -f $HOME/.bash_profile ]] || !(grep -wq '.bash_profile' -e '\.bashrc'))
then
    echo '. "$HOME/.bashrc"' >> .bash_profile
fi

ssh-keyscan -H arcadia.yandex.ru 2>/dev/null 1>> ~/.ssh/known_hosts
cat > ~/.gitconfig << EOF
[user]
	email = $(whoami)@yandex-team.ru
[core]
	excludesfile = ~/.gitignore
	editor = nano
[color]
        interactive = auto
        ui = auto
	diff = auto
	status = auto
	branch = auto
[alias]
	co = checkout
	ci = commit
	up = remote update
	st = status
	dp = diff --patience
	plog = log --oneline --abbrev-commit --name-status --graph --decorate
	log1 = log --oneline --abbrev-commit
	wdiff = diff --color-words --word-diff-regex='[^[:space:]]|([[:alnum:]]|UTF_8_GUARD)+'
[pull]
        rebase = true
EOF

# C++
sudo apt -y install clang-format-9
if ! command -v clang-format &> /dev/null
then
    sudo ln -s /usr/bin/clang-format-9 /usr/bin/clang-format
fi

# Docker
sudo apt -y install docker-compose
sudo usermod -aG docker $USER

# Utils
sudo apt -y install \
    apache2-utils `# ab` \
    jq

# tvm_curl
svn export svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/mail/rtec/setup/tvm_curl ~/tvm_curl
sudo mv ~/tvm_curl /usr/bin/tvm_curl && chmod +x /usr/bin/tvm_curl

# Manual setup
cat << EOF
1. setup docker
a. get token at https://oauth.yandex-team.ru/authorize?response_type=token&client_id=12225edea41e4add87aaa4c4896431f1
b. docker login -u $(whoami) registry.yandex.net
EOF
