#!/usr/bin/env python3

from startrek_client import Startrek
from os.path import expanduser
import subprocess
import time

with open(expanduser("~/.startrek.token"), "r") as file:
    startrek_token = file.read().strip()

def mine_requests(client):
    query = "Type: Жалоба Queue: RTEC Text: Удаление данных мейлишей Status: Открыт"
    uids = []
    issues = []
    for issue in client.issues.find(query):
        uid = None
        for line in issue.description.split("\n"):
            words = line.split(" ")
            if len(words) != 2:
                continue
            if words[0].lower() != "uid:":
                continue
            if not words[1].isdigit():
                continue
            uid = words[1]
            break
        if uid is None:
            print ("uid not found for {}".format(issue.key))
            continue
        uids.append(uid)
        issues.append(issue)
    return uids, issues

def move_issues_to_state(issues, state):
    for issue in issues:
        issue.transitions[state].execute()
        time.sleep(0.02)

def add_comment_to_issues(issues, text):
    for issue in issues:
        issue.comments.create(text=text)
        time.sleep(0.02)

def xeno_host():
    output = request(["executer", "-c", "describe", "%xeno"]).split("\n")
    output = list(filter(lambda line: "qloud-c.yandex.net" in line, output))
    return output[0]

def load_husky_tvm_token(host):
    execute_on_host(host, ["cat", "/etc/xeno/tvm_secret", "|", "ya", "tool", "tvmknife", "get_service_ticket", "client_credentials", "--src 2000328", "--dst 2011268", ">", "/root/.husky_tvm_ticket"])

def invalidate_auth_data(host):
    execute_on_host(host, ["/usr/share/xeno/invalidate_auth.py", "/root/uids", "100"])

def purge_user_data(host):
    execute_on_host(host, ["/usr/share/xeno/purge_users.py", "/root/uids", "100"])

def request(cmd):
    return subprocess.check_output(cmd, stderr=subprocess.STDOUT).decode("utf-8")

def execute_on_host(host, cmd):
    execute(["ssh", host] + cmd)

def execute(cmd):
    subprocess.check_call(cmd)

def write_uids_to_remote(host, uids):
    local_path = expanduser("~/mailish_uids")
    with open(local_path, "w") as file:
        for uid in uids:
            file.write(uid + "\n")
    remote_path = "/root/uids"
    execute(["scp", local_path, "{}:{}".format(host, remote_path)])

def dump_logs(host):
    execute(["ssh", host, "tail /ephemeral/logs/xeno/invalidate_auth.log"])
    execute(["ssh", host, "tail /ephemeral/logs/purge_users.log"])


client = Startrek(useragent="python", base_url="https://st-api.yandex-team.ru", token=startrek_token)

uids, issues = mine_requests(client)

if len(uids) == 0:
    print ("nothing to do")
    exit(0)

host = xeno_host()
write_uids_to_remote(host, uids)
load_husky_tvm_token(host)

move_issues_to_state(issues, 'inProgress')

invalidate_auth_data(host)
purge_user_data(host)
dump_logs(host)

add_comment_to_issues(issues, 'Готово')
move_issues_to_state(issues, 'naStoroneSapporta')

for idx in range(len(uids)):
    print ("{} {} done".format(issues[idx].key, uids[idx]))
