# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to link ephemeral, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/.pgpass ]]; then
        echo "copying pgpass"
        cp -f /secrets/.pgpass /etc/yamail/.pgpass

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No pgpass found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "[ERROR] Failed to chown pgpass, cannot start"
    exit 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -f /secrets/pgca.pem ]]; then
        echo "copying pgca"
        cp -f /secrets/pgca.pem /etc/yamail/pgca.pem

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No pgca found, sleeping"
        sleep 5
    fi
done

chmod 644 /etc/logrotate.d/*
