from contextlib import closing
from datetime import timedelta

import yaml
from mail.python.theatre.stages.db_stats.types import DbSignal, TierRunPolicy


def timedelta_yaml_constructor(loader, node):
    return timedelta(**loader.construct_mapping(node))


def tier_run_policy_constructor(loader, node):
    return TierRunPolicy(loader.construct_scalar(node))


yaml.add_constructor('!TimeDelta', timedelta_yaml_constructor, Loader=yaml.SafeLoader)
yaml.add_constructor('!TierRunPolicy', tier_run_policy_constructor, Loader=yaml.SafeLoader)


def load_config_file(filename):
    config = None
    with closing(open(filename)) as fd:
        try:
            config = yaml.safe_load(fd)
        except yaml.YAMLError as exc:
            raise Exception(f'Broken config {filename}: {exc}')

    for key in ['sharpei', 'db_host_status_poll_time', 'signals']:
        if key not in config:
            raise Exception(f'Missing key {key} in config file {filename}')

    signals = [
        DbSignal(**signal)
        for signal in config['signals']
    ]
    config['signals'] = signals

    return config
